package zio.aws.iottwinmaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataConnector(
    lambda: Optional[zio.aws.iottwinmaker.model.LambdaFunction] =
      Optional.Absent,
    isNative: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.DataConnector = {
    import DataConnector.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.DataConnector
      .builder()
      .optionallyWith(lambda.map(value => value.buildAwsValue()))(_.lambda)
      .optionallyWith(isNative.map(value => value: java.lang.Boolean))(
        _.isNative
      )
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.DataConnector.ReadOnly =
    zio.aws.iottwinmaker.model.DataConnector.wrap(buildAwsValue())
}
object DataConnector {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.DataConnector
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.DataConnector =
      zio.aws.iottwinmaker.model.DataConnector(
        lambda.map(value => value.asEditable),
        isNative.map(value => value)
      )
    def lambda: Optional[zio.aws.iottwinmaker.model.LambdaFunction.ReadOnly]
    def isNative: Optional[Boolean]
    def getLambda: ZIO[
      Any,
      AwsError,
      zio.aws.iottwinmaker.model.LambdaFunction.ReadOnly
    ] = AwsError.unwrapOptionField("lambda", lambda)
    def getIsNative: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isNative", isNative)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.DataConnector
  ) extends zio.aws.iottwinmaker.model.DataConnector.ReadOnly {
    override val lambda
        : Optional[zio.aws.iottwinmaker.model.LambdaFunction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lambda())
        .map(value => zio.aws.iottwinmaker.model.LambdaFunction.wrap(value))
    override val isNative: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isNative())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.DataConnector
  ): zio.aws.iottwinmaker.model.DataConnector.ReadOnly = new Wrapper(impl)
}
