package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{SyncSource, Id}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteSyncJobRequest(workspaceId: Id, syncSource: SyncSource) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.DeleteSyncJobRequest = {
    import DeleteSyncJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.DeleteSyncJobRequest
      .builder()
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .syncSource(SyncSource.unwrap(syncSource): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.DeleteSyncJobRequest.ReadOnly =
    zio.aws.iottwinmaker.model.DeleteSyncJobRequest.wrap(buildAwsValue())
}
object DeleteSyncJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.DeleteSyncJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.DeleteSyncJobRequest =
      zio.aws.iottwinmaker.model.DeleteSyncJobRequest(workspaceId, syncSource)
    def workspaceId: Id
    def syncSource: SyncSource
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
    def getSyncSource: ZIO[Any, Nothing, SyncSource] = ZIO.succeed(syncSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.DeleteSyncJobRequest
  ) extends zio.aws.iottwinmaker.model.DeleteSyncJobRequest.ReadOnly {
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
    override val syncSource: SyncSource =
      zio.aws.iottwinmaker.model.primitives.SyncSource(impl.syncSource())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.DeleteSyncJobRequest
  ): zio.aws.iottwinmaker.model.DeleteSyncJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
