package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ExecuteQueryResponse(
    columnDescriptions: Optional[
      Iterable[zio.aws.iottwinmaker.model.ColumnDescription]
    ] = Optional.Absent,
    rows: Optional[Iterable[zio.aws.iottwinmaker.model.Row]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryResponse = {
    import ExecuteQueryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryResponse
      .builder()
      .optionallyWith(
        columnDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.columnDescriptions)
      .optionallyWith(
        rows.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rows)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.ExecuteQueryResponse.ReadOnly =
    zio.aws.iottwinmaker.model.ExecuteQueryResponse.wrap(buildAwsValue())
}
object ExecuteQueryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ExecuteQueryResponse =
      zio.aws.iottwinmaker.model.ExecuteQueryResponse(
        columnDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        rows.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def columnDescriptions
        : Optional[List[zio.aws.iottwinmaker.model.ColumnDescription.ReadOnly]]
    def rows: Optional[List[zio.aws.iottwinmaker.model.Row.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getColumnDescriptions: ZIO[Any, AwsError, List[
      zio.aws.iottwinmaker.model.ColumnDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("columnDescriptions", columnDescriptions)
    def getRows
        : ZIO[Any, AwsError, List[zio.aws.iottwinmaker.model.Row.ReadOnly]] =
      AwsError.unwrapOptionField("rows", rows)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryResponse
  ) extends zio.aws.iottwinmaker.model.ExecuteQueryResponse.ReadOnly {
    override val columnDescriptions: Optional[
      List[zio.aws.iottwinmaker.model.ColumnDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.columnDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iottwinmaker.model.ColumnDescription.wrap(item)
        }.toList
      )
    override val rows: Optional[List[zio.aws.iottwinmaker.model.Row.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rows())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iottwinmaker.model.Row.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iottwinmaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryResponse
  ): zio.aws.iottwinmaker.model.ExecuteQueryResponse.ReadOnly = new Wrapper(
    impl
  )
}
