package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{NextToken, Name}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetPropertyValueResponse(
    propertyValues: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyLatestValue]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    tabularPropertyValues: Optional[
      Iterable[Iterable[Map[Name, zio.aws.iottwinmaker.model.DataValue]]]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueResponse = {
    import GetPropertyValueResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueResponse
      .builder()
      .optionallyWith(
        propertyValues.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.propertyValues)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        tabularPropertyValues.map(value =>
          value.map { item =>
            item.map { item =>
              item
                .map({ case (key, value) =>
                  (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
                })
                .asJava
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.tabularPropertyValues)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.GetPropertyValueResponse.ReadOnly =
    zio.aws.iottwinmaker.model.GetPropertyValueResponse.wrap(buildAwsValue())
}
object GetPropertyValueResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.GetPropertyValueResponse =
      zio.aws.iottwinmaker.model.GetPropertyValueResponse(
        propertyValues.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        nextToken.map(value => value),
        tabularPropertyValues.map(value =>
          value.map { item =>
            item.map { item =>
              item.map({ case (key, value) =>
                key -> value.asEditable
              })
            }
          }
        )
      )
    def propertyValues: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyLatestValue.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def tabularPropertyValues: Optional[
      List[List[Map[Name, zio.aws.iottwinmaker.model.DataValue.ReadOnly]]]
    ]
    def getPropertyValues: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.iottwinmaker.model.PropertyLatestValue.ReadOnly
    ]] = AwsError.unwrapOptionField("propertyValues", propertyValues)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTabularPropertyValues: ZIO[Any, AwsError, List[
      List[Map[Name, zio.aws.iottwinmaker.model.DataValue.ReadOnly]]
    ]] =
      AwsError.unwrapOptionField("tabularPropertyValues", tabularPropertyValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueResponse
  ) extends zio.aws.iottwinmaker.model.GetPropertyValueResponse.ReadOnly {
    override val propertyValues: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyLatestValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyValues())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.Name(
              key
            ) -> zio.aws.iottwinmaker.model.PropertyLatestValue.wrap(value)
          })
          .toMap
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iottwinmaker.model.primitives.NextToken(value))
    override val tabularPropertyValues: Optional[
      List[List[Map[Name, zio.aws.iottwinmaker.model.DataValue.ReadOnly]]]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tabularPropertyValues())
      .map(value =>
        value.asScala.map { item =>
          item.asScala.map { item =>
            item.asScala
              .map({ case (key, value) =>
                zio.aws.iottwinmaker.model.primitives
                  .Name(key) -> zio.aws.iottwinmaker.model.DataValue.wrap(value)
              })
              .toMap
          }.toList
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueResponse
  ): zio.aws.iottwinmaker.model.GetPropertyValueResponse.ReadOnly = new Wrapper(
    impl
  )
}
