package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{Id, SyncSource}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetSyncJobRequest(
    syncSource: SyncSource,
    workspaceId: Optional[Id] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.GetSyncJobRequest = {
    import GetSyncJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.GetSyncJobRequest
      .builder()
      .syncSource(SyncSource.unwrap(syncSource): java.lang.String)
      .optionallyWith(
        workspaceId.map(value => Id.unwrap(value): java.lang.String)
      )(_.workspaceId)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.GetSyncJobRequest.ReadOnly =
    zio.aws.iottwinmaker.model.GetSyncJobRequest.wrap(buildAwsValue())
}
object GetSyncJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.GetSyncJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.GetSyncJobRequest =
      zio.aws.iottwinmaker.model
        .GetSyncJobRequest(syncSource, workspaceId.map(value => value))
    def syncSource: SyncSource
    def workspaceId: Optional[Id]
    def getSyncSource: ZIO[Any, Nothing, SyncSource] = ZIO.succeed(syncSource)
    def getWorkspaceId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("workspaceId", workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetSyncJobRequest
  ) extends zio.aws.iottwinmaker.model.GetSyncJobRequest.ReadOnly {
    override val syncSource: SyncSource =
      zio.aws.iottwinmaker.model.primitives.SyncSource(impl.syncSource())
    override val workspaceId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.workspaceId())
      .map(value => zio.aws.iottwinmaker.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetSyncJobRequest
  ): zio.aws.iottwinmaker.model.GetSyncJobRequest.ReadOnly = new Wrapper(impl)
}
