package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{
  RoleArn,
  TwinMakerArn,
  Timestamp,
  SyncSource,
  Id
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class GetSyncJobResponse(
    arn: TwinMakerArn,
    workspaceId: Id,
    syncSource: SyncSource,
    syncRole: RoleArn,
    status: zio.aws.iottwinmaker.model.SyncJobStatus,
    creationDateTime: Timestamp,
    updateDateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.GetSyncJobResponse = {
    import GetSyncJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.GetSyncJobResponse
      .builder()
      .arn(TwinMakerArn.unwrap(arn): java.lang.String)
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .syncSource(SyncSource.unwrap(syncSource): java.lang.String)
      .syncRole(RoleArn.unwrap(syncRole): java.lang.String)
      .status(status.buildAwsValue())
      .creationDateTime(Timestamp.unwrap(creationDateTime): Instant)
      .updateDateTime(Timestamp.unwrap(updateDateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.GetSyncJobResponse.ReadOnly =
    zio.aws.iottwinmaker.model.GetSyncJobResponse.wrap(buildAwsValue())
}
object GetSyncJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.GetSyncJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.GetSyncJobResponse =
      zio.aws.iottwinmaker.model.GetSyncJobResponse(
        arn,
        workspaceId,
        syncSource,
        syncRole,
        status.asEditable,
        creationDateTime,
        updateDateTime
      )
    def arn: TwinMakerArn
    def workspaceId: Id
    def syncSource: SyncSource
    def syncRole: RoleArn
    def status: zio.aws.iottwinmaker.model.SyncJobStatus.ReadOnly
    def creationDateTime: Timestamp
    def updateDateTime: Timestamp
    def getArn: ZIO[Any, Nothing, TwinMakerArn] = ZIO.succeed(arn)
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
    def getSyncSource: ZIO[Any, Nothing, SyncSource] = ZIO.succeed(syncSource)
    def getSyncRole: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(syncRole)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.iottwinmaker.model.SyncJobStatus.ReadOnly] =
      ZIO.succeed(status)
    def getCreationDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDateTime)
    def getUpdateDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(updateDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetSyncJobResponse
  ) extends zio.aws.iottwinmaker.model.GetSyncJobResponse.ReadOnly {
    override val arn: TwinMakerArn =
      zio.aws.iottwinmaker.model.primitives.TwinMakerArn(impl.arn())
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
    override val syncSource: SyncSource =
      zio.aws.iottwinmaker.model.primitives.SyncSource(impl.syncSource())
    override val syncRole: RoleArn =
      zio.aws.iottwinmaker.model.primitives.RoleArn(impl.syncRole())
    override val status: zio.aws.iottwinmaker.model.SyncJobStatus.ReadOnly =
      zio.aws.iottwinmaker.model.SyncJobStatus.wrap(impl.status())
    override val creationDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.creationDateTime())
    override val updateDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.updateDateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetSyncJobResponse
  ): zio.aws.iottwinmaker.model.GetSyncJobResponse.ReadOnly = new Wrapper(impl)
}
