package zio.aws.iottwinmaker.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iottwinmaker.model.primitives.{MaxResults, NextToken, Id}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListComponentTypesRequest(
    workspaceId: Id,
    filters: Optional[
      Iterable[zio.aws.iottwinmaker.model.ListComponentTypesFilter]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesRequest = {
    import ListComponentTypesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesRequest
      .builder()
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.iottwinmaker.model.ListComponentTypesRequest.ReadOnly =
    zio.aws.iottwinmaker.model.ListComponentTypesRequest.wrap(buildAwsValue())
}
object ListComponentTypesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ListComponentTypesRequest =
      zio.aws.iottwinmaker.model.ListComponentTypesRequest(
        workspaceId,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def workspaceId: Id
    def filters: Optional[
      List[zio.aws.iottwinmaker.model.ListComponentTypesFilter.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.iottwinmaker.model.ListComponentTypesFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesRequest
  ) extends zio.aws.iottwinmaker.model.ListComponentTypesRequest.ReadOnly {
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
    override val filters: Optional[
      List[zio.aws.iottwinmaker.model.ListComponentTypesFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iottwinmaker.model.ListComponentTypesFilter.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iottwinmaker.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iottwinmaker.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesRequest
  ): zio.aws.iottwinmaker.model.ListComponentTypesRequest.ReadOnly =
    new Wrapper(impl)
}
