package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListScenesResponse(
    sceneSummaries: Optional[
      Iterable[zio.aws.iottwinmaker.model.SceneSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ListScenesResponse = {
    import ListScenesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ListScenesResponse
      .builder()
      .optionallyWith(
        sceneSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sceneSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.ListScenesResponse.ReadOnly =
    zio.aws.iottwinmaker.model.ListScenesResponse.wrap(buildAwsValue())
}
object ListScenesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ListScenesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ListScenesResponse =
      zio.aws.iottwinmaker.model.ListScenesResponse(
        sceneSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def sceneSummaries
        : Optional[List[zio.aws.iottwinmaker.model.SceneSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getSceneSummaries: ZIO[Any, AwsError, List[
      zio.aws.iottwinmaker.model.SceneSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("sceneSummaries", sceneSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListScenesResponse
  ) extends zio.aws.iottwinmaker.model.ListScenesResponse.ReadOnly {
    override val sceneSummaries
        : Optional[List[zio.aws.iottwinmaker.model.SceneSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sceneSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iottwinmaker.model.SceneSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iottwinmaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListScenesResponse
  ): zio.aws.iottwinmaker.model.ListScenesResponse.ReadOnly = new Wrapper(impl)
}
