package zio.aws.iottwinmaker.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iottwinmaker.model.primitives.{
  NextToken,
  MaxResults,
  SyncSource,
  Id
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListSyncResourcesRequest(
    workspaceId: Id,
    syncSource: SyncSource,
    filters: Optional[Iterable[zio.aws.iottwinmaker.model.SyncResourceFilter]] =
      Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesRequest = {
    import ListSyncResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesRequest
      .builder()
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .syncSource(SyncSource.unwrap(syncSource): java.lang.String)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.ListSyncResourcesRequest.ReadOnly =
    zio.aws.iottwinmaker.model.ListSyncResourcesRequest.wrap(buildAwsValue())
}
object ListSyncResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ListSyncResourcesRequest =
      zio.aws.iottwinmaker.model.ListSyncResourcesRequest(
        workspaceId,
        syncSource,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def workspaceId: Id
    def syncSource: SyncSource
    def filters
        : Optional[List[zio.aws.iottwinmaker.model.SyncResourceFilter.ReadOnly]]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
    def getSyncSource: ZIO[Any, Nothing, SyncSource] = ZIO.succeed(syncSource)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.iottwinmaker.model.SyncResourceFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesRequest
  ) extends zio.aws.iottwinmaker.model.ListSyncResourcesRequest.ReadOnly {
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
    override val syncSource: SyncSource =
      zio.aws.iottwinmaker.model.primitives.SyncSource(impl.syncSource())
    override val filters: Optional[
      List[zio.aws.iottwinmaker.model.SyncResourceFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iottwinmaker.model.SyncResourceFilter.wrap(item)
        }.toList
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iottwinmaker.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iottwinmaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesRequest
  ): zio.aws.iottwinmaker.model.ListSyncResourcesRequest.ReadOnly = new Wrapper(
    impl
  )
}
