package zio.aws.iottwinmaker.model
import scala.jdk.CollectionConverters.*
sealed trait Order {
  def unwrap: software.amazon.awssdk.services.iottwinmaker.model.Order
}
object Order {
  def wrap(
      value: software.amazon.awssdk.services.iottwinmaker.model.Order
  ): zio.aws.iottwinmaker.model.Order = value match {
    case software.amazon.awssdk.services.iottwinmaker.model.Order.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iottwinmaker.model.Order.ASCENDING =>
      val r = ASCENDING
      r
    case software.amazon.awssdk.services.iottwinmaker.model.Order.DESCENDING =>
      val r = DESCENDING
      r
  }
  case object unknownToSdkVersion extends zio.aws.iottwinmaker.model.Order {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.Order =
      software.amazon.awssdk.services.iottwinmaker.model.Order.UNKNOWN_TO_SDK_VERSION
  }
  case object ASCENDING extends zio.aws.iottwinmaker.model.Order {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.Order =
      software.amazon.awssdk.services.iottwinmaker.model.Order.ASCENDING
  }
  case object DESCENDING extends zio.aws.iottwinmaker.model.Order {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.Order =
      software.amazon.awssdk.services.iottwinmaker.model.Order.DESCENDING
  }
}
