package zio.aws.iottwinmaker.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iottwinmaker.model.primitives.{Time, Timestamp}
import scala.jdk.CollectionConverters.*
final case class PropertyValue(
    timestamp: Optional[Timestamp] = Optional.Absent,
    value: zio.aws.iottwinmaker.model.DataValue,
    time: Optional[Time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.PropertyValue = {
    import PropertyValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.PropertyValue
      .builder()
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .value(value.buildAwsValue())
      .optionallyWith(time.map(value => Time.unwrap(value): java.lang.String))(
        _.time
      )
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.PropertyValue.ReadOnly =
    zio.aws.iottwinmaker.model.PropertyValue.wrap(buildAwsValue())
}
object PropertyValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.PropertyValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.PropertyValue =
      zio.aws.iottwinmaker.model.PropertyValue(
        timestamp.map(value => value),
        value.asEditable,
        time.map(value => value)
      )
    def timestamp: Optional[Timestamp]
    def value: zio.aws.iottwinmaker.model.DataValue.ReadOnly
    def time: Optional[Time]
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getValue
        : ZIO[Any, Nothing, zio.aws.iottwinmaker.model.DataValue.ReadOnly] =
      ZIO.succeed(value)
    def getTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("time", time)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyValue
  ) extends zio.aws.iottwinmaker.model.PropertyValue.ReadOnly {
    override val timestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => zio.aws.iottwinmaker.model.primitives.Timestamp(value))
    override val value: zio.aws.iottwinmaker.model.DataValue.ReadOnly =
      zio.aws.iottwinmaker.model.DataValue.wrap(impl.value())
    override val time: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.time())
      .map(value => zio.aws.iottwinmaker.model.primitives.Time(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyValue
  ): zio.aws.iottwinmaker.model.PropertyValue.ReadOnly = new Wrapper(impl)
}
