package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{Name, EntityId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RelationshipValue(
    targetEntityId: Optional[EntityId] = Optional.Absent,
    targetComponentName: Optional[Name] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.RelationshipValue = {
    import RelationshipValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.RelationshipValue
      .builder()
      .optionallyWith(
        targetEntityId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.targetEntityId)
      .optionallyWith(
        targetComponentName.map(value => Name.unwrap(value): java.lang.String)
      )(_.targetComponentName)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.RelationshipValue.ReadOnly =
    zio.aws.iottwinmaker.model.RelationshipValue.wrap(buildAwsValue())
}
object RelationshipValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.RelationshipValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.RelationshipValue =
      zio.aws.iottwinmaker.model.RelationshipValue(
        targetEntityId.map(value => value),
        targetComponentName.map(value => value)
      )
    def targetEntityId: Optional[EntityId]
    def targetComponentName: Optional[Name]
    def getTargetEntityId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("targetEntityId", targetEntityId)
    def getTargetComponentName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("targetComponentName", targetComponentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.RelationshipValue
  ) extends zio.aws.iottwinmaker.model.RelationshipValue.ReadOnly {
    override val targetEntityId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.targetEntityId())
      .map(value => zio.aws.iottwinmaker.model.primitives.EntityId(value))
    override val targetComponentName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.targetComponentName())
      .map(value => zio.aws.iottwinmaker.model.primitives.Name(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.RelationshipValue
  ): zio.aws.iottwinmaker.model.RelationshipValue.ReadOnly = new Wrapper(impl)
}
