package zio.aws.iottwinmaker.model
import software.amazon.awssdk.core.document.Document
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Row(
    rowData: Optional[Iterable[zio.aws.iottwinmaker.model.QueryResultValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.Row = {
    import Row.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.Row
      .builder()
      .optionallyWith(rowData.map(value => value.asJavaCollection))(_.rowData)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.Row.ReadOnly =
    zio.aws.iottwinmaker.model.Row.wrap(buildAwsValue())
}
object Row {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iottwinmaker.model.Row] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.Row =
      zio.aws.iottwinmaker.model.Row(rowData.map(value => value))
    def rowData: Optional[List[Document]]
    def getRowData: ZIO[Any, AwsError, List[Document]] =
      AwsError.unwrapOptionField("rowData", rowData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.Row
  ) extends zio.aws.iottwinmaker.model.Row.ReadOnly {
    override val rowData: Optional[List[Document]] = zio.aws.core.internal
      .optionalFromNullable(impl.rowData())
      .map(value => value.asScala.toList)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.Row
  ): zio.aws.iottwinmaker.model.Row.ReadOnly = new Wrapper(impl)
}
