package zio.aws.iottwinmaker.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iottwinmaker.model.primitives.{
  TwinMakerArn,
  Timestamp,
  S3Url,
  Description,
  Id
}
import scala.jdk.CollectionConverters.*
final case class SceneSummary(
    sceneId: Id,
    contentLocation: S3Url,
    arn: TwinMakerArn,
    creationDateTime: Timestamp,
    updateDateTime: Timestamp,
    description: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.SceneSummary = {
    import SceneSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.SceneSummary
      .builder()
      .sceneId(Id.unwrap(sceneId): java.lang.String)
      .contentLocation(S3Url.unwrap(contentLocation): java.lang.String)
      .arn(TwinMakerArn.unwrap(arn): java.lang.String)
      .creationDateTime(Timestamp.unwrap(creationDateTime): Instant)
      .updateDateTime(Timestamp.unwrap(updateDateTime): Instant)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.SceneSummary.ReadOnly =
    zio.aws.iottwinmaker.model.SceneSummary.wrap(buildAwsValue())
}
object SceneSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.SceneSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.SceneSummary =
      zio.aws.iottwinmaker.model.SceneSummary(
        sceneId,
        contentLocation,
        arn,
        creationDateTime,
        updateDateTime,
        description.map(value => value)
      )
    def sceneId: Id
    def contentLocation: S3Url
    def arn: TwinMakerArn
    def creationDateTime: Timestamp
    def updateDateTime: Timestamp
    def description: Optional[Description]
    def getSceneId: ZIO[Any, Nothing, Id] = ZIO.succeed(sceneId)
    def getContentLocation: ZIO[Any, Nothing, S3Url] =
      ZIO.succeed(contentLocation)
    def getArn: ZIO[Any, Nothing, TwinMakerArn] = ZIO.succeed(arn)
    def getCreationDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDateTime)
    def getUpdateDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(updateDateTime)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.SceneSummary
  ) extends zio.aws.iottwinmaker.model.SceneSummary.ReadOnly {
    override val sceneId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.sceneId())
    override val contentLocation: S3Url =
      zio.aws.iottwinmaker.model.primitives.S3Url(impl.contentLocation())
    override val arn: TwinMakerArn =
      zio.aws.iottwinmaker.model.primitives.TwinMakerArn(impl.arn())
    override val creationDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.creationDateTime())
    override val updateDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.updateDateTime())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.SceneSummary
  ): zio.aws.iottwinmaker.model.SceneSummary.ReadOnly = new Wrapper(impl)
}
