package zio.aws.iottwinmaker.model
import scala.jdk.CollectionConverters.*
sealed trait Scope {
  def unwrap: software.amazon.awssdk.services.iottwinmaker.model.Scope
}
object Scope {
  def wrap(
      value: software.amazon.awssdk.services.iottwinmaker.model.Scope
  ): zio.aws.iottwinmaker.model.Scope = value match {
    case software.amazon.awssdk.services.iottwinmaker.model.Scope.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iottwinmaker.model.Scope.ENTITY =>
      val r = ENTITY
      r
    case software.amazon.awssdk.services.iottwinmaker.model.Scope.WORKSPACE =>
      val r = WORKSPACE
      r
  }
  case object unknownToSdkVersion extends zio.aws.iottwinmaker.model.Scope {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.Scope =
      software.amazon.awssdk.services.iottwinmaker.model.Scope.UNKNOWN_TO_SDK_VERSION
  }
  case object ENTITY extends zio.aws.iottwinmaker.model.Scope {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.Scope =
      software.amazon.awssdk.services.iottwinmaker.model.Scope.ENTITY
  }
  case object WORKSPACE extends zio.aws.iottwinmaker.model.Scope {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.Scope =
      software.amazon.awssdk.services.iottwinmaker.model.Scope.WORKSPACE
  }
}
