package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{
  ComponentTypeName,
  Description,
  ComponentTypeId,
  Name,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateComponentTypeRequest(
    workspaceId: Id,
    isSingleton: Optional[Boolean] = Optional.Absent,
    componentTypeId: ComponentTypeId,
    description: Optional[Description] = Optional.Absent,
    propertyDefinitions: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyDefinitionRequest]
    ] = Optional.Absent,
    extendsFrom: Optional[Iterable[ComponentTypeId]] = Optional.Absent,
    functions: Optional[Map[Name, zio.aws.iottwinmaker.model.FunctionRequest]] =
      Optional.Absent,
    propertyGroups: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyGroupRequest]
    ] = Optional.Absent,
    componentTypeName: Optional[ComponentTypeName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.UpdateComponentTypeRequest = {
    import UpdateComponentTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.UpdateComponentTypeRequest
      .builder()
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .optionallyWith(isSingleton.map(value => value: java.lang.Boolean))(
        _.isSingleton
      )
      .componentTypeId(
        ComponentTypeId.unwrap(componentTypeId): java.lang.String
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        propertyDefinitions.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.propertyDefinitions)
      .optionallyWith(
        extendsFrom.map(value =>
          value.map { item =>
            ComponentTypeId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.extendsFrom)
      .optionallyWith(
        functions.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.functions)
      .optionallyWith(
        propertyGroups.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.propertyGroups)
      .optionallyWith(
        componentTypeName.map(value =>
          ComponentTypeName.unwrap(value): java.lang.String
        )
      )(_.componentTypeName)
      .build()
  }
  def asReadOnly
      : zio.aws.iottwinmaker.model.UpdateComponentTypeRequest.ReadOnly =
    zio.aws.iottwinmaker.model.UpdateComponentTypeRequest.wrap(buildAwsValue())
}
object UpdateComponentTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.UpdateComponentTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.UpdateComponentTypeRequest =
      zio.aws.iottwinmaker.model.UpdateComponentTypeRequest(
        workspaceId,
        isSingleton.map(value => value),
        componentTypeId,
        description.map(value => value),
        propertyDefinitions.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        extendsFrom.map(value => value),
        functions.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        propertyGroups.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        componentTypeName.map(value => value)
      )
    def workspaceId: Id
    def isSingleton: Optional[Boolean]
    def componentTypeId: ComponentTypeId
    def description: Optional[Description]
    def propertyDefinitions: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyDefinitionRequest.ReadOnly]
    ]
    def extendsFrom: Optional[List[ComponentTypeId]]
    def functions: Optional[
      Map[Name, zio.aws.iottwinmaker.model.FunctionRequest.ReadOnly]
    ]
    def propertyGroups: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyGroupRequest.ReadOnly]
    ]
    def componentTypeName: Optional[ComponentTypeName]
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
    def getIsSingleton: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isSingleton", isSingleton)
    def getComponentTypeId: ZIO[Any, Nothing, ComponentTypeId] =
      ZIO.succeed(componentTypeId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getPropertyDefinitions: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.iottwinmaker.model.PropertyDefinitionRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("propertyDefinitions", propertyDefinitions)
    def getExtendsFrom: ZIO[Any, AwsError, List[ComponentTypeId]] =
      AwsError.unwrapOptionField("extendsFrom", extendsFrom)
    def getFunctions: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.iottwinmaker.model.FunctionRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("functions", functions)
    def getPropertyGroups: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.iottwinmaker.model.PropertyGroupRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("propertyGroups", propertyGroups)
    def getComponentTypeName: ZIO[Any, AwsError, ComponentTypeName] =
      AwsError.unwrapOptionField("componentTypeName", componentTypeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.UpdateComponentTypeRequest
  ) extends zio.aws.iottwinmaker.model.UpdateComponentTypeRequest.ReadOnly {
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
    override val isSingleton: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isSingleton())
      .map(value => value: Boolean)
    override val componentTypeId: ComponentTypeId =
      zio.aws.iottwinmaker.model.primitives
        .ComponentTypeId(impl.componentTypeId())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val propertyDefinitions: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyDefinitionRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyDefinitions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives
              .Name(key) -> zio.aws.iottwinmaker.model.PropertyDefinitionRequest
              .wrap(value)
          })
          .toMap
      )
    override val extendsFrom: Optional[List[ComponentTypeId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.extendsFrom())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iottwinmaker.model.primitives.ComponentTypeId(item)
          }.toList
        )
    override val functions: Optional[
      Map[Name, zio.aws.iottwinmaker.model.FunctionRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.functions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.Name(
              key
            ) -> zio.aws.iottwinmaker.model.FunctionRequest.wrap(value)
          })
          .toMap
      )
    override val propertyGroups: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyGroupRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyGroups())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.Name(
              key
            ) -> zio.aws.iottwinmaker.model.PropertyGroupRequest.wrap(value)
          })
          .toMap
      )
    override val componentTypeName: Optional[ComponentTypeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.componentTypeName())
        .map(value =>
          zio.aws.iottwinmaker.model.primitives.ComponentTypeName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.UpdateComponentTypeRequest
  ): zio.aws.iottwinmaker.model.UpdateComponentTypeRequest.ReadOnly =
    new Wrapper(impl)
}
