package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class UpdateEntityResponse(
    updateDateTime: Timestamp,
    state: zio.aws.iottwinmaker.model.State
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.UpdateEntityResponse = {
    import UpdateEntityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.UpdateEntityResponse
      .builder()
      .updateDateTime(Timestamp.unwrap(updateDateTime): Instant)
      .state(state.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.UpdateEntityResponse.ReadOnly =
    zio.aws.iottwinmaker.model.UpdateEntityResponse.wrap(buildAwsValue())
}
object UpdateEntityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.UpdateEntityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.UpdateEntityResponse =
      zio.aws.iottwinmaker.model.UpdateEntityResponse(updateDateTime, state)
    def updateDateTime: Timestamp
    def state: zio.aws.iottwinmaker.model.State
    def getUpdateDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(updateDateTime)
    def getState: ZIO[Any, Nothing, zio.aws.iottwinmaker.model.State] =
      ZIO.succeed(state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.UpdateEntityResponse
  ) extends zio.aws.iottwinmaker.model.UpdateEntityResponse.ReadOnly {
    override val updateDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.updateDateTime())
    override val state: zio.aws.iottwinmaker.model.State =
      zio.aws.iottwinmaker.model.State.wrap(impl.state())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.UpdateEntityResponse
  ): zio.aws.iottwinmaker.model.UpdateEntityResponse.ReadOnly = new Wrapper(
    impl
  )
}
