package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class UpdateSceneResponse(updateDateTime: Timestamp) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.UpdateSceneResponse = {
    import UpdateSceneResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.UpdateSceneResponse
      .builder()
      .updateDateTime(Timestamp.unwrap(updateDateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.UpdateSceneResponse.ReadOnly =
    zio.aws.iottwinmaker.model.UpdateSceneResponse.wrap(buildAwsValue())
}
object UpdateSceneResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.UpdateSceneResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.UpdateSceneResponse =
      zio.aws.iottwinmaker.model.UpdateSceneResponse(updateDateTime)
    def updateDateTime: Timestamp
    def getUpdateDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(updateDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.UpdateSceneResponse
  ) extends zio.aws.iottwinmaker.model.UpdateSceneResponse.ReadOnly {
    override val updateDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.updateDateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.UpdateSceneResponse
  ): zio.aws.iottwinmaker.model.UpdateSceneResponse.ReadOnly = new Wrapper(impl)
}
