package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.ColumnName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ColumnDescription(
    name: Optional[ColumnName] = Optional.Absent,
    `type`: Optional[zio.aws.iottwinmaker.model.ColumnType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ColumnDescription = {
    import ColumnDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ColumnDescription
      .builder()
      .optionallyWith(
        name.map(value => ColumnName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.ColumnDescription.ReadOnly =
    zio.aws.iottwinmaker.model.ColumnDescription.wrap(buildAwsValue())
}
object ColumnDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ColumnDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ColumnDescription =
      zio.aws.iottwinmaker.model
        .ColumnDescription(name.map(value => value), `type`.map(value => value))
    def name: Optional[ColumnName]
    def `type`: Optional[zio.aws.iottwinmaker.model.ColumnType]
    def getName: ZIO[Any, AwsError, ColumnName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.iottwinmaker.model.ColumnType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ColumnDescription
  ) extends zio.aws.iottwinmaker.model.ColumnDescription.ReadOnly {
    override val name: Optional[ColumnName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.iottwinmaker.model.primitives.ColumnName(value))
    override val `type`: Optional[zio.aws.iottwinmaker.model.ColumnType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.iottwinmaker.model.ColumnType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ColumnDescription
  ): zio.aws.iottwinmaker.model.ColumnDescription.ReadOnly = new Wrapper(impl)
}
