package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{
  Name,
  ComponentTypeId,
  Description
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ComponentRequest(
    description: Optional[Description] = Optional.Absent,
    componentTypeId: Optional[ComponentTypeId] = Optional.Absent,
    properties: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyRequest]
    ] = Optional.Absent,
    propertyGroups: Optional[
      Map[Name, zio.aws.iottwinmaker.model.ComponentPropertyGroupRequest]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ComponentRequest = {
    import ComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ComponentRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        componentTypeId.map(value =>
          ComponentTypeId.unwrap(value): java.lang.String
        )
      )(_.componentTypeId)
      .optionallyWith(
        properties.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.properties)
      .optionallyWith(
        propertyGroups.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.propertyGroups)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.ComponentRequest.ReadOnly =
    zio.aws.iottwinmaker.model.ComponentRequest.wrap(buildAwsValue())
}
object ComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ComponentRequest =
      zio.aws.iottwinmaker.model.ComponentRequest(
        description.map(value => value),
        componentTypeId.map(value => value),
        properties.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        propertyGroups.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def description: Optional[Description]
    def componentTypeId: Optional[ComponentTypeId]
    def properties: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyRequest.ReadOnly]
    ]
    def propertyGroups: Optional[Map[
      Name,
      zio.aws.iottwinmaker.model.ComponentPropertyGroupRequest.ReadOnly
    ]]
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getComponentTypeId: ZIO[Any, AwsError, ComponentTypeId] =
      AwsError.unwrapOptionField("componentTypeId", componentTypeId)
    def getProperties: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.iottwinmaker.model.PropertyRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("properties", properties)
    def getPropertyGroups: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.iottwinmaker.model.ComponentPropertyGroupRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("propertyGroups", propertyGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ComponentRequest
  ) extends zio.aws.iottwinmaker.model.ComponentRequest.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val componentTypeId: Optional[ComponentTypeId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.componentTypeId())
        .map(value =>
          zio.aws.iottwinmaker.model.primitives.ComponentTypeId(value)
        )
    override val properties: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.properties())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.Name(
              key
            ) -> zio.aws.iottwinmaker.model.PropertyRequest.wrap(value)
          })
          .toMap
      )
    override val propertyGroups: Optional[Map[
      Name,
      zio.aws.iottwinmaker.model.ComponentPropertyGroupRequest.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyGroups())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.Name(
              key
            ) -> zio.aws.iottwinmaker.model.ComponentPropertyGroupRequest
              .wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ComponentRequest
  ): zio.aws.iottwinmaker.model.ComponentRequest.ReadOnly = new Wrapper(impl)
}
