package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{
  SyncSource,
  ComponentTypeId,
  Description,
  Name
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ComponentResponse(
    componentName: Optional[Name] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    componentTypeId: Optional[ComponentTypeId] = Optional.Absent,
    status: Optional[zio.aws.iottwinmaker.model.Status] = Optional.Absent,
    definedIn: Optional[String] = Optional.Absent,
    properties: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyResponse]
    ] = Optional.Absent,
    propertyGroups: Optional[
      Map[Name, zio.aws.iottwinmaker.model.ComponentPropertyGroupResponse]
    ] = Optional.Absent,
    syncSource: Optional[SyncSource] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ComponentResponse = {
    import ComponentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ComponentResponse
      .builder()
      .optionallyWith(
        componentName.map(value => Name.unwrap(value): java.lang.String)
      )(_.componentName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        componentTypeId.map(value =>
          ComponentTypeId.unwrap(value): java.lang.String
        )
      )(_.componentTypeId)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(definedIn.map(value => value: java.lang.String))(
        _.definedIn
      )
      .optionallyWith(
        properties.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.properties)
      .optionallyWith(
        propertyGroups.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.propertyGroups)
      .optionallyWith(
        syncSource.map(value => SyncSource.unwrap(value): java.lang.String)
      )(_.syncSource)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.ComponentResponse.ReadOnly =
    zio.aws.iottwinmaker.model.ComponentResponse.wrap(buildAwsValue())
}
object ComponentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ComponentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ComponentResponse =
      zio.aws.iottwinmaker.model.ComponentResponse(
        componentName.map(value => value),
        description.map(value => value),
        componentTypeId.map(value => value),
        status.map(value => value.asEditable),
        definedIn.map(value => value),
        properties.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        propertyGroups.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        syncSource.map(value => value)
      )
    def componentName: Optional[Name]
    def description: Optional[Description]
    def componentTypeId: Optional[ComponentTypeId]
    def status: Optional[zio.aws.iottwinmaker.model.Status.ReadOnly]
    def definedIn: Optional[String]
    def properties: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyResponse.ReadOnly]
    ]
    def propertyGroups: Optional[Map[
      Name,
      zio.aws.iottwinmaker.model.ComponentPropertyGroupResponse.ReadOnly
    ]]
    def syncSource: Optional[SyncSource]
    def getComponentName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("componentName", componentName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getComponentTypeId: ZIO[Any, AwsError, ComponentTypeId] =
      AwsError.unwrapOptionField("componentTypeId", componentTypeId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.Status.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
    def getDefinedIn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("definedIn", definedIn)
    def getProperties: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.iottwinmaker.model.PropertyResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("properties", properties)
    def getPropertyGroups: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.iottwinmaker.model.ComponentPropertyGroupResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("propertyGroups", propertyGroups)
    def getSyncSource: ZIO[Any, AwsError, SyncSource] =
      AwsError.unwrapOptionField("syncSource", syncSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ComponentResponse
  ) extends zio.aws.iottwinmaker.model.ComponentResponse.ReadOnly {
    override val componentName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.componentName())
      .map(value => zio.aws.iottwinmaker.model.primitives.Name(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val componentTypeId: Optional[ComponentTypeId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.componentTypeId())
        .map(value =>
          zio.aws.iottwinmaker.model.primitives.ComponentTypeId(value)
        )
    override val status: Optional[zio.aws.iottwinmaker.model.Status.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iottwinmaker.model.Status.wrap(value))
    override val definedIn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.definedIn())
      .map(value => value: String)
    override val properties: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyResponse.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.properties())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.Name(
              key
            ) -> zio.aws.iottwinmaker.model.PropertyResponse.wrap(value)
          })
          .toMap
      )
    override val propertyGroups: Optional[Map[
      Name,
      zio.aws.iottwinmaker.model.ComponentPropertyGroupResponse.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyGroups())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.Name(
              key
            ) -> zio.aws.iottwinmaker.model.ComponentPropertyGroupResponse
              .wrap(value)
          })
          .toMap
      )
    override val syncSource: Optional[SyncSource] = zio.aws.core.internal
      .optionalFromNullable(impl.syncSource())
      .map(value => zio.aws.iottwinmaker.model.primitives.SyncSource(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ComponentResponse
  ): zio.aws.iottwinmaker.model.ComponentResponse.ReadOnly = new Wrapper(impl)
}
