package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{Timestamp, TwinMakerArn, EntityId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CreateEntityResponse(
    entityId: EntityId,
    arn: TwinMakerArn,
    creationDateTime: Timestamp,
    state: zio.aws.iottwinmaker.model.State
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.CreateEntityResponse = {
    import CreateEntityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.CreateEntityResponse
      .builder()
      .entityId(EntityId.unwrap(entityId): java.lang.String)
      .arn(TwinMakerArn.unwrap(arn): java.lang.String)
      .creationDateTime(Timestamp.unwrap(creationDateTime): Instant)
      .state(state.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.CreateEntityResponse.ReadOnly =
    zio.aws.iottwinmaker.model.CreateEntityResponse.wrap(buildAwsValue())
}
object CreateEntityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.CreateEntityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.CreateEntityResponse =
      zio.aws.iottwinmaker.model.CreateEntityResponse(
        entityId,
        arn,
        creationDateTime,
        state
      )
    def entityId: EntityId
    def arn: TwinMakerArn
    def creationDateTime: Timestamp
    def state: zio.aws.iottwinmaker.model.State
    def getEntityId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(entityId)
    def getArn: ZIO[Any, Nothing, TwinMakerArn] = ZIO.succeed(arn)
    def getCreationDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDateTime)
    def getState: ZIO[Any, Nothing, zio.aws.iottwinmaker.model.State] =
      ZIO.succeed(state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.CreateEntityResponse
  ) extends zio.aws.iottwinmaker.model.CreateEntityResponse.ReadOnly {
    override val entityId: EntityId =
      zio.aws.iottwinmaker.model.primitives.EntityId(impl.entityId())
    override val arn: TwinMakerArn =
      zio.aws.iottwinmaker.model.primitives.TwinMakerArn(impl.arn())
    override val creationDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.creationDateTime())
    override val state: zio.aws.iottwinmaker.model.State =
      zio.aws.iottwinmaker.model.State.wrap(impl.state())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.CreateEntityResponse
  ): zio.aws.iottwinmaker.model.CreateEntityResponse.ReadOnly = new Wrapper(
    impl
  )
}
