package zio.aws.iottwinmaker.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iottwinmaker.model.primitives.{
  TwinMakerArn,
  Timestamp,
  ComponentTypeName,
  SyncSource,
  Description,
  ComponentTypeId,
  Name,
  Id
}
import scala.jdk.CollectionConverters.*
final case class GetComponentTypeResponse(
    workspaceId: Id,
    isSingleton: Optional[Boolean] = Optional.Absent,
    componentTypeId: ComponentTypeId,
    description: Optional[Description] = Optional.Absent,
    propertyDefinitions: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyDefinitionResponse]
    ] = Optional.Absent,
    extendsFrom: Optional[Iterable[ComponentTypeId]] = Optional.Absent,
    functions: Optional[
      Map[Name, zio.aws.iottwinmaker.model.FunctionResponse]
    ] = Optional.Absent,
    creationDateTime: Timestamp,
    updateDateTime: Timestamp,
    arn: TwinMakerArn,
    isAbstract: Optional[Boolean] = Optional.Absent,
    isSchemaInitialized: Optional[Boolean] = Optional.Absent,
    status: Optional[zio.aws.iottwinmaker.model.Status] = Optional.Absent,
    propertyGroups: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyGroupResponse]
    ] = Optional.Absent,
    syncSource: Optional[SyncSource] = Optional.Absent,
    componentTypeName: Optional[ComponentTypeName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeResponse = {
    import GetComponentTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeResponse
      .builder()
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .optionallyWith(isSingleton.map(value => value: java.lang.Boolean))(
        _.isSingleton
      )
      .componentTypeId(
        ComponentTypeId.unwrap(componentTypeId): java.lang.String
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        propertyDefinitions.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.propertyDefinitions)
      .optionallyWith(
        extendsFrom.map(value =>
          value.map { item =>
            ComponentTypeId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.extendsFrom)
      .optionallyWith(
        functions.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.functions)
      .creationDateTime(Timestamp.unwrap(creationDateTime): Instant)
      .updateDateTime(Timestamp.unwrap(updateDateTime): Instant)
      .arn(TwinMakerArn.unwrap(arn): java.lang.String)
      .optionallyWith(isAbstract.map(value => value: java.lang.Boolean))(
        _.isAbstract
      )
      .optionallyWith(
        isSchemaInitialized.map(value => value: java.lang.Boolean)
      )(_.isSchemaInitialized)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(
        propertyGroups.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.propertyGroups)
      .optionallyWith(
        syncSource.map(value => SyncSource.unwrap(value): java.lang.String)
      )(_.syncSource)
      .optionallyWith(
        componentTypeName.map(value =>
          ComponentTypeName.unwrap(value): java.lang.String
        )
      )(_.componentTypeName)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.GetComponentTypeResponse.ReadOnly =
    zio.aws.iottwinmaker.model.GetComponentTypeResponse.wrap(buildAwsValue())
}
object GetComponentTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.GetComponentTypeResponse =
      zio.aws.iottwinmaker.model.GetComponentTypeResponse(
        workspaceId,
        isSingleton.map(value => value),
        componentTypeId,
        description.map(value => value),
        propertyDefinitions.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        extendsFrom.map(value => value),
        functions.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        creationDateTime,
        updateDateTime,
        arn,
        isAbstract.map(value => value),
        isSchemaInitialized.map(value => value),
        status.map(value => value.asEditable),
        propertyGroups.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        syncSource.map(value => value),
        componentTypeName.map(value => value)
      )
    def workspaceId: Id
    def isSingleton: Optional[Boolean]
    def componentTypeId: ComponentTypeId
    def description: Optional[Description]
    def propertyDefinitions: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyDefinitionResponse.ReadOnly]
    ]
    def extendsFrom: Optional[List[ComponentTypeId]]
    def functions: Optional[
      Map[Name, zio.aws.iottwinmaker.model.FunctionResponse.ReadOnly]
    ]
    def creationDateTime: Timestamp
    def updateDateTime: Timestamp
    def arn: TwinMakerArn
    def isAbstract: Optional[Boolean]
    def isSchemaInitialized: Optional[Boolean]
    def status: Optional[zio.aws.iottwinmaker.model.Status.ReadOnly]
    def propertyGroups: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyGroupResponse.ReadOnly]
    ]
    def syncSource: Optional[SyncSource]
    def componentTypeName: Optional[ComponentTypeName]
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
    def getIsSingleton: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isSingleton", isSingleton)
    def getComponentTypeId: ZIO[Any, Nothing, ComponentTypeId] =
      ZIO.succeed(componentTypeId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getPropertyDefinitions: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.iottwinmaker.model.PropertyDefinitionResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("propertyDefinitions", propertyDefinitions)
    def getExtendsFrom: ZIO[Any, AwsError, List[ComponentTypeId]] =
      AwsError.unwrapOptionField("extendsFrom", extendsFrom)
    def getFunctions: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.iottwinmaker.model.FunctionResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("functions", functions)
    def getCreationDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDateTime)
    def getUpdateDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(updateDateTime)
    def getArn: ZIO[Any, Nothing, TwinMakerArn] = ZIO.succeed(arn)
    def getIsAbstract: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isAbstract", isAbstract)
    def getIsSchemaInitialized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isSchemaInitialized", isSchemaInitialized)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.Status.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
    def getPropertyGroups: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.iottwinmaker.model.PropertyGroupResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("propertyGroups", propertyGroups)
    def getSyncSource: ZIO[Any, AwsError, SyncSource] =
      AwsError.unwrapOptionField("syncSource", syncSource)
    def getComponentTypeName: ZIO[Any, AwsError, ComponentTypeName] =
      AwsError.unwrapOptionField("componentTypeName", componentTypeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeResponse
  ) extends zio.aws.iottwinmaker.model.GetComponentTypeResponse.ReadOnly {
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
    override val isSingleton: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isSingleton())
      .map(value => value: Boolean)
    override val componentTypeId: ComponentTypeId =
      zio.aws.iottwinmaker.model.primitives
        .ComponentTypeId(impl.componentTypeId())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val propertyDefinitions: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyDefinitionResponse.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyDefinitions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.Name(
              key
            ) -> zio.aws.iottwinmaker.model.PropertyDefinitionResponse
              .wrap(value)
          })
          .toMap
      )
    override val extendsFrom: Optional[List[ComponentTypeId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.extendsFrom())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iottwinmaker.model.primitives.ComponentTypeId(item)
          }.toList
        )
    override val functions: Optional[
      Map[Name, zio.aws.iottwinmaker.model.FunctionResponse.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.functions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.Name(
              key
            ) -> zio.aws.iottwinmaker.model.FunctionResponse.wrap(value)
          })
          .toMap
      )
    override val creationDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.creationDateTime())
    override val updateDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.updateDateTime())
    override val arn: TwinMakerArn =
      zio.aws.iottwinmaker.model.primitives.TwinMakerArn(impl.arn())
    override val isAbstract: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isAbstract())
      .map(value => value: Boolean)
    override val isSchemaInitialized: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isSchemaInitialized())
      .map(value => value: Boolean)
    override val status: Optional[zio.aws.iottwinmaker.model.Status.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iottwinmaker.model.Status.wrap(value))
    override val propertyGroups: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyGroupResponse.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyGroups())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.Name(
              key
            ) -> zio.aws.iottwinmaker.model.PropertyGroupResponse.wrap(value)
          })
          .toMap
      )
    override val syncSource: Optional[SyncSource] = zio.aws.core.internal
      .optionalFromNullable(impl.syncSource())
      .map(value => zio.aws.iottwinmaker.model.primitives.SyncSource(value))
    override val componentTypeName: Optional[ComponentTypeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.componentTypeName())
        .map(value =>
          zio.aws.iottwinmaker.model.primitives.ComponentTypeName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeResponse
  ): zio.aws.iottwinmaker.model.GetComponentTypeResponse.ReadOnly = new Wrapper(
    impl
  )
}
