package zio.aws.iottwinmaker.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iottwinmaker.model.primitives.{
  SceneMetadataValue,
  TwinMakerArn,
  SceneCapability,
  Timestamp,
  S3Url,
  Description,
  Name,
  Id
}
import scala.jdk.CollectionConverters.*
final case class GetSceneResponse(
    workspaceId: Id,
    sceneId: Id,
    contentLocation: S3Url,
    arn: TwinMakerArn,
    creationDateTime: Timestamp,
    updateDateTime: Timestamp,
    description: Optional[Description] = Optional.Absent,
    capabilities: Optional[Iterable[SceneCapability]] = Optional.Absent,
    sceneMetadata: Optional[Map[Name, SceneMetadataValue]] = Optional.Absent,
    generatedSceneMetadata: Optional[Map[Name, SceneMetadataValue]] =
      Optional.Absent,
    error: Optional[zio.aws.iottwinmaker.model.SceneError] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.GetSceneResponse = {
    import GetSceneResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.GetSceneResponse
      .builder()
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .sceneId(Id.unwrap(sceneId): java.lang.String)
      .contentLocation(S3Url.unwrap(contentLocation): java.lang.String)
      .arn(TwinMakerArn.unwrap(arn): java.lang.String)
      .creationDateTime(Timestamp.unwrap(creationDateTime): Instant)
      .updateDateTime(Timestamp.unwrap(updateDateTime): Instant)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            SceneCapability.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.capabilities)
      .optionallyWith(
        sceneMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> (SceneMetadataValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.sceneMetadata)
      .optionallyWith(
        generatedSceneMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> (SceneMetadataValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.generatedSceneMetadata)
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.GetSceneResponse.ReadOnly =
    zio.aws.iottwinmaker.model.GetSceneResponse.wrap(buildAwsValue())
}
object GetSceneResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.GetSceneResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.GetSceneResponse =
      zio.aws.iottwinmaker.model.GetSceneResponse(
        workspaceId,
        sceneId,
        contentLocation,
        arn,
        creationDateTime,
        updateDateTime,
        description.map(value => value),
        capabilities.map(value => value),
        sceneMetadata.map(value => value),
        generatedSceneMetadata.map(value => value),
        error.map(value => value.asEditable)
      )
    def workspaceId: Id
    def sceneId: Id
    def contentLocation: S3Url
    def arn: TwinMakerArn
    def creationDateTime: Timestamp
    def updateDateTime: Timestamp
    def description: Optional[Description]
    def capabilities: Optional[List[SceneCapability]]
    def sceneMetadata: Optional[Map[Name, SceneMetadataValue]]
    def generatedSceneMetadata: Optional[Map[Name, SceneMetadataValue]]
    def error: Optional[zio.aws.iottwinmaker.model.SceneError.ReadOnly]
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
    def getSceneId: ZIO[Any, Nothing, Id] = ZIO.succeed(sceneId)
    def getContentLocation: ZIO[Any, Nothing, S3Url] =
      ZIO.succeed(contentLocation)
    def getArn: ZIO[Any, Nothing, TwinMakerArn] = ZIO.succeed(arn)
    def getCreationDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDateTime)
    def getUpdateDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(updateDateTime)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCapabilities: ZIO[Any, AwsError, List[SceneCapability]] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getSceneMetadata: ZIO[Any, AwsError, Map[Name, SceneMetadataValue]] =
      AwsError.unwrapOptionField("sceneMetadata", sceneMetadata)
    def getGeneratedSceneMetadata
        : ZIO[Any, AwsError, Map[Name, SceneMetadataValue]] = AwsError
      .unwrapOptionField("generatedSceneMetadata", generatedSceneMetadata)
    def getError
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.SceneError.ReadOnly] =
      AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetSceneResponse
  ) extends zio.aws.iottwinmaker.model.GetSceneResponse.ReadOnly {
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
    override val sceneId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.sceneId())
    override val contentLocation: S3Url =
      zio.aws.iottwinmaker.model.primitives.S3Url(impl.contentLocation())
    override val arn: TwinMakerArn =
      zio.aws.iottwinmaker.model.primitives.TwinMakerArn(impl.arn())
    override val creationDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.creationDateTime())
    override val updateDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.updateDateTime())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val capabilities: Optional[List[SceneCapability]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capabilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iottwinmaker.model.primitives.SceneCapability(item)
          }.toList
        )
    override val sceneMetadata: Optional[Map[Name, SceneMetadataValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sceneMetadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iottwinmaker.model.primitives
                .Name(key) -> zio.aws.iottwinmaker.model.primitives
                .SceneMetadataValue(value)
            })
            .toMap
        )
    override val generatedSceneMetadata
        : Optional[Map[Name, SceneMetadataValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.generatedSceneMetadata())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.Name(
              key
            ) -> zio.aws.iottwinmaker.model.primitives.SceneMetadataValue(value)
          })
          .toMap
      )
    override val error
        : Optional[zio.aws.iottwinmaker.model.SceneError.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.error())
        .map(value => zio.aws.iottwinmaker.model.SceneError.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetSceneResponse
  ): zio.aws.iottwinmaker.model.GetSceneResponse.ReadOnly = new Wrapper(impl)
}
