package zio.aws.iottwinmaker.model
import scala.jdk.CollectionConverters.*
sealed trait InterpolationType {
  def unwrap
      : software.amazon.awssdk.services.iottwinmaker.model.InterpolationType
}
object InterpolationType {
  def wrap(
      value: software.amazon.awssdk.services.iottwinmaker.model.InterpolationType
  ): zio.aws.iottwinmaker.model.InterpolationType = value match {
    case software.amazon.awssdk.services.iottwinmaker.model.InterpolationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iottwinmaker.model.InterpolationType.LINEAR =>
      val r = LINEAR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iottwinmaker.model.InterpolationType {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.InterpolationType =
      software.amazon.awssdk.services.iottwinmaker.model.InterpolationType.UNKNOWN_TO_SDK_VERSION
  }
  case object LINEAR extends zio.aws.iottwinmaker.model.InterpolationType {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.InterpolationType =
      software.amazon.awssdk.services.iottwinmaker.model.InterpolationType.LINEAR
  }
}
