package zio.aws.iottwinmaker.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iottwinmaker.model.primitives.{NextToken, MaxResults, Id}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListEntitiesRequest(
    workspaceId: Id,
    filters: Optional[Iterable[zio.aws.iottwinmaker.model.ListEntitiesFilter]] =
      Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesRequest = {
    import ListEntitiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesRequest
      .builder()
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.ListEntitiesRequest.ReadOnly =
    zio.aws.iottwinmaker.model.ListEntitiesRequest.wrap(buildAwsValue())
}
object ListEntitiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ListEntitiesRequest =
      zio.aws.iottwinmaker.model.ListEntitiesRequest(
        workspaceId,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def workspaceId: Id
    def filters
        : Optional[List[zio.aws.iottwinmaker.model.ListEntitiesFilter.ReadOnly]]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.iottwinmaker.model.ListEntitiesFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesRequest
  ) extends zio.aws.iottwinmaker.model.ListEntitiesRequest.ReadOnly {
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
    override val filters: Optional[
      List[zio.aws.iottwinmaker.model.ListEntitiesFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iottwinmaker.model.ListEntitiesFilter.wrap(item)
        }.toList
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iottwinmaker.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iottwinmaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesRequest
  ): zio.aws.iottwinmaker.model.ListEntitiesRequest.ReadOnly = new Wrapper(impl)
}
