package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListEntitiesResponse(
    entitySummaries: Optional[
      Iterable[zio.aws.iottwinmaker.model.EntitySummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesResponse = {
    import ListEntitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesResponse
      .builder()
      .optionallyWith(
        entitySummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entitySummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.ListEntitiesResponse.ReadOnly =
    zio.aws.iottwinmaker.model.ListEntitiesResponse.wrap(buildAwsValue())
}
object ListEntitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ListEntitiesResponse =
      zio.aws.iottwinmaker.model.ListEntitiesResponse(
        entitySummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def entitySummaries
        : Optional[List[zio.aws.iottwinmaker.model.EntitySummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getEntitySummaries: ZIO[Any, AwsError, List[
      zio.aws.iottwinmaker.model.EntitySummary.ReadOnly
    ]] = AwsError.unwrapOptionField("entitySummaries", entitySummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesResponse
  ) extends zio.aws.iottwinmaker.model.ListEntitiesResponse.ReadOnly {
    override val entitySummaries
        : Optional[List[zio.aws.iottwinmaker.model.EntitySummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entitySummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iottwinmaker.model.EntitySummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iottwinmaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesResponse
  ): zio.aws.iottwinmaker.model.ListEntitiesResponse.ReadOnly = new Wrapper(
    impl
  )
}
