package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListSyncJobsResponse(
    syncJobSummaries: Optional[
      Iterable[zio.aws.iottwinmaker.model.SyncJobSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsResponse = {
    import ListSyncJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsResponse
      .builder()
      .optionallyWith(
        syncJobSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.syncJobSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.ListSyncJobsResponse.ReadOnly =
    zio.aws.iottwinmaker.model.ListSyncJobsResponse.wrap(buildAwsValue())
}
object ListSyncJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ListSyncJobsResponse =
      zio.aws.iottwinmaker.model.ListSyncJobsResponse(
        syncJobSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def syncJobSummaries
        : Optional[List[zio.aws.iottwinmaker.model.SyncJobSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getSyncJobSummaries: ZIO[Any, AwsError, List[
      zio.aws.iottwinmaker.model.SyncJobSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("syncJobSummaries", syncJobSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsResponse
  ) extends zio.aws.iottwinmaker.model.ListSyncJobsResponse.ReadOnly {
    override val syncJobSummaries
        : Optional[List[zio.aws.iottwinmaker.model.SyncJobSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.syncJobSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iottwinmaker.model.SyncJobSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iottwinmaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsResponse
  ): zio.aws.iottwinmaker.model.ListSyncJobsResponse.ReadOnly = new Wrapper(
    impl
  )
}
