package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListSyncResourcesResponse(
    syncResources: Optional[
      Iterable[zio.aws.iottwinmaker.model.SyncResourceSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesResponse = {
    import ListSyncResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesResponse
      .builder()
      .optionallyWith(
        syncResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.syncResources)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iottwinmaker.model.ListSyncResourcesResponse.ReadOnly =
    zio.aws.iottwinmaker.model.ListSyncResourcesResponse.wrap(buildAwsValue())
}
object ListSyncResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ListSyncResourcesResponse =
      zio.aws.iottwinmaker.model.ListSyncResourcesResponse(
        syncResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def syncResources: Optional[
      List[zio.aws.iottwinmaker.model.SyncResourceSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getSyncResources: ZIO[Any, AwsError, List[
      zio.aws.iottwinmaker.model.SyncResourceSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("syncResources", syncResources)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesResponse
  ) extends zio.aws.iottwinmaker.model.ListSyncResourcesResponse.ReadOnly {
    override val syncResources: Optional[
      List[zio.aws.iottwinmaker.model.SyncResourceSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.syncResources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iottwinmaker.model.SyncResourceSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iottwinmaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesResponse
  ): zio.aws.iottwinmaker.model.ListSyncResourcesResponse.ReadOnly =
    new Wrapper(impl)
}
