package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.ParentEntityId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ParentEntityUpdateRequest(
    updateType: zio.aws.iottwinmaker.model.ParentEntityUpdateType,
    parentEntityId: Optional[ParentEntityId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ParentEntityUpdateRequest = {
    import ParentEntityUpdateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ParentEntityUpdateRequest
      .builder()
      .updateType(updateType.unwrap)
      .optionallyWith(
        parentEntityId.map(value =>
          ParentEntityId.unwrap(value): java.lang.String
        )
      )(_.parentEntityId)
      .build()
  }
  def asReadOnly
      : zio.aws.iottwinmaker.model.ParentEntityUpdateRequest.ReadOnly =
    zio.aws.iottwinmaker.model.ParentEntityUpdateRequest.wrap(buildAwsValue())
}
object ParentEntityUpdateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ParentEntityUpdateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ParentEntityUpdateRequest =
      zio.aws.iottwinmaker.model.ParentEntityUpdateRequest(
        updateType,
        parentEntityId.map(value => value)
      )
    def updateType: zio.aws.iottwinmaker.model.ParentEntityUpdateType
    def parentEntityId: Optional[ParentEntityId]
    def getUpdateType
        : ZIO[Any, Nothing, zio.aws.iottwinmaker.model.ParentEntityUpdateType] =
      ZIO.succeed(updateType)
    def getParentEntityId: ZIO[Any, AwsError, ParentEntityId] =
      AwsError.unwrapOptionField("parentEntityId", parentEntityId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ParentEntityUpdateRequest
  ) extends zio.aws.iottwinmaker.model.ParentEntityUpdateRequest.ReadOnly {
    override val updateType: zio.aws.iottwinmaker.model.ParentEntityUpdateType =
      zio.aws.iottwinmaker.model.ParentEntityUpdateType.wrap(impl.updateType())
    override val parentEntityId: Optional[ParentEntityId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parentEntityId())
        .map(value =>
          zio.aws.iottwinmaker.model.primitives.ParentEntityId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ParentEntityUpdateRequest
  ): zio.aws.iottwinmaker.model.ParentEntityUpdateRequest.ReadOnly =
    new Wrapper(impl)
}
