package zio.aws.iottwinmaker.model
import scala.jdk.CollectionConverters.*
sealed trait PricingMode {
  def unwrap: software.amazon.awssdk.services.iottwinmaker.model.PricingMode
}
object PricingMode {
  def wrap(
      value: software.amazon.awssdk.services.iottwinmaker.model.PricingMode
  ): zio.aws.iottwinmaker.model.PricingMode = value match {
    case software.amazon.awssdk.services.iottwinmaker.model.PricingMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iottwinmaker.model.PricingMode.BASIC =>
      val r = BASIC
      r
    case software.amazon.awssdk.services.iottwinmaker.model.PricingMode.STANDARD =>
      val r = STANDARD
      r
    case software.amazon.awssdk.services.iottwinmaker.model.PricingMode.TIERED_BUNDLE =>
      val r = TIERED_BUNDLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iottwinmaker.model.PricingMode {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.PricingMode =
      software.amazon.awssdk.services.iottwinmaker.model.PricingMode.UNKNOWN_TO_SDK_VERSION
  }
  case object BASIC extends zio.aws.iottwinmaker.model.PricingMode {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.PricingMode =
      software.amazon.awssdk.services.iottwinmaker.model.PricingMode.BASIC
  }
  case object STANDARD extends zio.aws.iottwinmaker.model.PricingMode {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.PricingMode =
      software.amazon.awssdk.services.iottwinmaker.model.PricingMode.STANDARD
  }
  case object TIERED_BUNDLE extends zio.aws.iottwinmaker.model.PricingMode {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.PricingMode =
      software.amazon.awssdk.services.iottwinmaker.model.PricingMode.TIERED_BUNDLE
  }
}
