package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{PropertyDisplayName, Value, Name}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PropertyDefinitionResponse(
    dataType: zio.aws.iottwinmaker.model.DataType,
    isTimeSeries: Boolean,
    isRequiredInEntity: Boolean,
    isExternalId: Boolean,
    isStoredExternally: Boolean,
    isImported: Boolean,
    isFinal: Boolean,
    isInherited: Boolean,
    defaultValue: Optional[zio.aws.iottwinmaker.model.DataValue] =
      Optional.Absent,
    configuration: Optional[Map[Name, Value]] = Optional.Absent,
    displayName: Optional[PropertyDisplayName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.PropertyDefinitionResponse = {
    import PropertyDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.PropertyDefinitionResponse
      .builder()
      .dataType(dataType.buildAwsValue())
      .isTimeSeries(isTimeSeries: java.lang.Boolean)
      .isRequiredInEntity(isRequiredInEntity: java.lang.Boolean)
      .isExternalId(isExternalId: java.lang.Boolean)
      .isStoredExternally(isStoredExternally: java.lang.Boolean)
      .isImported(isImported: java.lang.Boolean)
      .isFinal(isFinal: java.lang.Boolean)
      .isInherited(isInherited: java.lang.Boolean)
      .optionallyWith(defaultValue.map(value => value.buildAwsValue()))(
        _.defaultValue
      )
      .optionallyWith(
        configuration.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> (Value
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.configuration)
      .optionallyWith(
        displayName.map(value =>
          PropertyDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .build()
  }
  def asReadOnly
      : zio.aws.iottwinmaker.model.PropertyDefinitionResponse.ReadOnly =
    zio.aws.iottwinmaker.model.PropertyDefinitionResponse.wrap(buildAwsValue())
}
object PropertyDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.PropertyDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.PropertyDefinitionResponse =
      zio.aws.iottwinmaker.model.PropertyDefinitionResponse(
        dataType.asEditable,
        isTimeSeries,
        isRequiredInEntity,
        isExternalId,
        isStoredExternally,
        isImported,
        isFinal,
        isInherited,
        defaultValue.map(value => value.asEditable),
        configuration.map(value => value),
        displayName.map(value => value)
      )
    def dataType: zio.aws.iottwinmaker.model.DataType.ReadOnly
    def isTimeSeries: Boolean
    def isRequiredInEntity: Boolean
    def isExternalId: Boolean
    def isStoredExternally: Boolean
    def isImported: Boolean
    def isFinal: Boolean
    def isInherited: Boolean
    def defaultValue: Optional[zio.aws.iottwinmaker.model.DataValue.ReadOnly]
    def configuration: Optional[Map[Name, Value]]
    def displayName: Optional[PropertyDisplayName]
    def getDataType
        : ZIO[Any, Nothing, zio.aws.iottwinmaker.model.DataType.ReadOnly] =
      ZIO.succeed(dataType)
    def getIsTimeSeries: ZIO[Any, Nothing, Boolean] = ZIO.succeed(isTimeSeries)
    def getIsRequiredInEntity: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(isRequiredInEntity)
    def getIsExternalId: ZIO[Any, Nothing, Boolean] = ZIO.succeed(isExternalId)
    def getIsStoredExternally: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(isStoredExternally)
    def getIsImported: ZIO[Any, Nothing, Boolean] = ZIO.succeed(isImported)
    def getIsFinal: ZIO[Any, Nothing, Boolean] = ZIO.succeed(isFinal)
    def getIsInherited: ZIO[Any, Nothing, Boolean] = ZIO.succeed(isInherited)
    def getDefaultValue
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.DataValue.ReadOnly] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getConfiguration: ZIO[Any, AwsError, Map[Name, Value]] =
      AwsError.unwrapOptionField("configuration", configuration)
    def getDisplayName: ZIO[Any, AwsError, PropertyDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyDefinitionResponse
  ) extends zio.aws.iottwinmaker.model.PropertyDefinitionResponse.ReadOnly {
    override val dataType: zio.aws.iottwinmaker.model.DataType.ReadOnly =
      zio.aws.iottwinmaker.model.DataType.wrap(impl.dataType())
    override val isTimeSeries: Boolean = impl.isTimeSeries(): Boolean
    override val isRequiredInEntity: Boolean =
      impl.isRequiredInEntity(): Boolean
    override val isExternalId: Boolean = impl.isExternalId(): Boolean
    override val isStoredExternally: Boolean =
      impl.isStoredExternally(): Boolean
    override val isImported: Boolean = impl.isImported(): Boolean
    override val isFinal: Boolean = impl.isFinal(): Boolean
    override val isInherited: Boolean = impl.isInherited(): Boolean
    override val defaultValue
        : Optional[zio.aws.iottwinmaker.model.DataValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultValue())
        .map(value => zio.aws.iottwinmaker.model.DataValue.wrap(value))
    override val configuration: Optional[Map[Name, Value]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configuration())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iottwinmaker.model.primitives
                .Name(key) -> zio.aws.iottwinmaker.model.primitives.Value(value)
            })
            .toMap
        )
    override val displayName: Optional[PropertyDisplayName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayName())
        .map(value =>
          zio.aws.iottwinmaker.model.primitives.PropertyDisplayName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyDefinitionResponse
  ): zio.aws.iottwinmaker.model.PropertyDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
