package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.ErrorMessage
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SceneError(
    code: Optional[zio.aws.iottwinmaker.model.SceneErrorCode] = Optional.Absent,
    message: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.SceneError = {
    import SceneError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.SceneError
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.SceneError.ReadOnly =
    zio.aws.iottwinmaker.model.SceneError.wrap(buildAwsValue())
}
object SceneError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.SceneError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.SceneError =
      zio.aws.iottwinmaker.model
        .SceneError(code.map(value => value), message.map(value => value))
    def code: Optional[zio.aws.iottwinmaker.model.SceneErrorCode]
    def message: Optional[ErrorMessage]
    def getCode: ZIO[Any, AwsError, zio.aws.iottwinmaker.model.SceneErrorCode] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.SceneError
  ) extends zio.aws.iottwinmaker.model.SceneError.ReadOnly {
    override val code: Optional[zio.aws.iottwinmaker.model.SceneErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value => zio.aws.iottwinmaker.model.SceneErrorCode.wrap(value))
    override val message: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.iottwinmaker.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.SceneError
  ): zio.aws.iottwinmaker.model.SceneError.ReadOnly = new Wrapper(impl)
}
