package zio.aws.iottwinmaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Status(
    state: Optional[zio.aws.iottwinmaker.model.State] = Optional.Absent,
    error: Optional[zio.aws.iottwinmaker.model.ErrorDetails] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.Status = {
    import Status.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.Status
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.Status.ReadOnly =
    zio.aws.iottwinmaker.model.Status.wrap(buildAwsValue())
}
object Status {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.Status
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.Status =
      zio.aws.iottwinmaker.model
        .Status(state.map(value => value), error.map(value => value.asEditable))
    def state: Optional[zio.aws.iottwinmaker.model.State]
    def error: Optional[zio.aws.iottwinmaker.model.ErrorDetails.ReadOnly]
    def getState: ZIO[Any, AwsError, zio.aws.iottwinmaker.model.State] =
      AwsError.unwrapOptionField("state", state)
    def getError
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.ErrorDetails.ReadOnly] =
      AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.Status
  ) extends zio.aws.iottwinmaker.model.Status.ReadOnly {
    override val state: Optional[zio.aws.iottwinmaker.model.State] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.iottwinmaker.model.State.wrap(value))
    override val error
        : Optional[zio.aws.iottwinmaker.model.ErrorDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.error())
        .map(value => zio.aws.iottwinmaker.model.ErrorDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.Status
  ): zio.aws.iottwinmaker.model.Status.ReadOnly = new Wrapper(impl)
}
