package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.Id
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SyncResourceFilter(
    state: Optional[zio.aws.iottwinmaker.model.SyncResourceState] =
      Optional.Absent,
    resourceType: Optional[zio.aws.iottwinmaker.model.SyncResourceType] =
      Optional.Absent,
    resourceId: Optional[Id] = Optional.Absent,
    externalId: Optional[Id] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.SyncResourceFilter = {
    import SyncResourceFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.SyncResourceFilter
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        resourceId.map(value => Id.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(
        externalId.map(value => Id.unwrap(value): java.lang.String)
      )(_.externalId)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.SyncResourceFilter.ReadOnly =
    zio.aws.iottwinmaker.model.SyncResourceFilter.wrap(buildAwsValue())
}
object SyncResourceFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.SyncResourceFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.SyncResourceFilter =
      zio.aws.iottwinmaker.model.SyncResourceFilter(
        state.map(value => value),
        resourceType.map(value => value),
        resourceId.map(value => value),
        externalId.map(value => value)
      )
    def state: Optional[zio.aws.iottwinmaker.model.SyncResourceState]
    def resourceType: Optional[zio.aws.iottwinmaker.model.SyncResourceType]
    def resourceId: Optional[Id]
    def externalId: Optional[Id]
    def getState
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.SyncResourceState] =
      AwsError.unwrapOptionField("state", state)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.SyncResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getExternalId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("externalId", externalId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.SyncResourceFilter
  ) extends zio.aws.iottwinmaker.model.SyncResourceFilter.ReadOnly {
    override val state: Optional[zio.aws.iottwinmaker.model.SyncResourceState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.iottwinmaker.model.SyncResourceState.wrap(value))
    override val resourceType
        : Optional[zio.aws.iottwinmaker.model.SyncResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.iottwinmaker.model.SyncResourceType.wrap(value))
    override val resourceId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => zio.aws.iottwinmaker.model.primitives.Id(value))
    override val externalId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.externalId())
      .map(value => zio.aws.iottwinmaker.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.SyncResourceFilter
  ): zio.aws.iottwinmaker.model.SyncResourceFilter.ReadOnly = new Wrapper(impl)
}
