package zio.aws.iottwinmaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SyncResourceStatus(
    state: Optional[zio.aws.iottwinmaker.model.SyncResourceState] =
      Optional.Absent,
    error: Optional[zio.aws.iottwinmaker.model.ErrorDetails] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.SyncResourceStatus = {
    import SyncResourceStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.SyncResourceStatus
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.SyncResourceStatus.ReadOnly =
    zio.aws.iottwinmaker.model.SyncResourceStatus.wrap(buildAwsValue())
}
object SyncResourceStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.SyncResourceStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.SyncResourceStatus =
      zio.aws.iottwinmaker.model.SyncResourceStatus(
        state.map(value => value),
        error.map(value => value.asEditable)
      )
    def state: Optional[zio.aws.iottwinmaker.model.SyncResourceState]
    def error: Optional[zio.aws.iottwinmaker.model.ErrorDetails.ReadOnly]
    def getState
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.SyncResourceState] =
      AwsError.unwrapOptionField("state", state)
    def getError
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.ErrorDetails.ReadOnly] =
      AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.SyncResourceStatus
  ) extends zio.aws.iottwinmaker.model.SyncResourceStatus.ReadOnly {
    override val state: Optional[zio.aws.iottwinmaker.model.SyncResourceState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.iottwinmaker.model.SyncResourceState.wrap(value))
    override val error
        : Optional[zio.aws.iottwinmaker.model.ErrorDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.error())
        .map(value => zio.aws.iottwinmaker.model.ErrorDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.SyncResourceStatus
  ): zio.aws.iottwinmaker.model.SyncResourceStatus.ReadOnly = new Wrapper(impl)
}
