package zio.aws.iottwinmaker.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iottwinmaker.model.primitives.{
  Timestamp,
  Description,
  TwinMakerArn,
  Id
}
import scala.jdk.CollectionConverters.*
final case class WorkspaceSummary(
    workspaceId: Id,
    arn: TwinMakerArn,
    description: Optional[Description] = Optional.Absent,
    creationDateTime: Timestamp,
    updateDateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.WorkspaceSummary = {
    import WorkspaceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.WorkspaceSummary
      .builder()
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .arn(TwinMakerArn.unwrap(arn): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .creationDateTime(Timestamp.unwrap(creationDateTime): Instant)
      .updateDateTime(Timestamp.unwrap(updateDateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.WorkspaceSummary.ReadOnly =
    zio.aws.iottwinmaker.model.WorkspaceSummary.wrap(buildAwsValue())
}
object WorkspaceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.WorkspaceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.WorkspaceSummary =
      zio.aws.iottwinmaker.model.WorkspaceSummary(
        workspaceId,
        arn,
        description.map(value => value),
        creationDateTime,
        updateDateTime
      )
    def workspaceId: Id
    def arn: TwinMakerArn
    def description: Optional[Description]
    def creationDateTime: Timestamp
    def updateDateTime: Timestamp
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
    def getArn: ZIO[Any, Nothing, TwinMakerArn] = ZIO.succeed(arn)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCreationDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDateTime)
    def getUpdateDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(updateDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.WorkspaceSummary
  ) extends zio.aws.iottwinmaker.model.WorkspaceSummary.ReadOnly {
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
    override val arn: TwinMakerArn =
      zio.aws.iottwinmaker.model.primitives.TwinMakerArn(impl.arn())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val creationDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.creationDateTime())
    override val updateDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.updateDateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.WorkspaceSummary
  ): zio.aws.iottwinmaker.model.WorkspaceSummary.ReadOnly = new Wrapper(impl)
}
