package zio.aws.iottwinmaker
import software.amazon.awssdk.core.document.Document
import zio.aws.iottwinmaker.model.primitives.{
  SceneMetadataValue,
  SceneCapability,
  TagValue,
  Value,
  ComponentTypeId,
  Name,
  BundleName,
  TagKey
}
import zio.prelude.Subtype
import java.time.Instant
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object BundleName extends Subtype[String]
    type BundleName = zio.aws.iottwinmaker.model.primitives.BundleName.Type
    object ColumnName extends Subtype[String]
    type ColumnName = zio.aws.iottwinmaker.model.primitives.ColumnName.Type
    object ComponentTypeId extends Subtype[String]
    type ComponentTypeId =
      zio.aws.iottwinmaker.model.primitives.ComponentTypeId.Type
    object ComponentTypeName extends Subtype[String]
    type ComponentTypeName =
      zio.aws.iottwinmaker.model.primitives.ComponentTypeName.Type
    object Description extends Subtype[String]
    type Description = zio.aws.iottwinmaker.model.primitives.Description.Type
    object EntityId extends Subtype[String]
    type EntityId = zio.aws.iottwinmaker.model.primitives.EntityId.Type
    object EntityName extends Subtype[String]
    type EntityName = zio.aws.iottwinmaker.model.primitives.EntityName.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage = zio.aws.iottwinmaker.model.primitives.ErrorMessage.Type
    object Expression extends Subtype[String]
    type Expression = zio.aws.iottwinmaker.model.primitives.Expression.Type
    object Id extends Subtype[String]
    type Id = zio.aws.iottwinmaker.model.primitives.Id.Type
    object IdOrArn extends Subtype[String]
    type IdOrArn = zio.aws.iottwinmaker.model.primitives.IdOrArn.Type
    type Integer = Int
    object IntervalInSeconds extends Subtype[Long]
    type IntervalInSeconds =
      zio.aws.iottwinmaker.model.primitives.IntervalInSeconds.Type
    object LambdaArn extends Subtype[String]
    type LambdaArn = zio.aws.iottwinmaker.model.primitives.LambdaArn.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.iottwinmaker.model.primitives.MaxResults.Type
    object Name extends Subtype[String]
    type Name = zio.aws.iottwinmaker.model.primitives.Name.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.iottwinmaker.model.primitives.NextToken.Type
    object ParentEntityId extends Subtype[String]
    type ParentEntityId =
      zio.aws.iottwinmaker.model.primitives.ParentEntityId.Type
    object PropertyDisplayName extends Subtype[String]
    type PropertyDisplayName =
      zio.aws.iottwinmaker.model.primitives.PropertyDisplayName.Type
    object QueryServiceMaxResults extends Subtype[Int]
    type QueryServiceMaxResults =
      zio.aws.iottwinmaker.model.primitives.QueryServiceMaxResults.Type
    object QueryStatement extends Subtype[String]
    type QueryStatement =
      zio.aws.iottwinmaker.model.primitives.QueryStatement.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.iottwinmaker.model.primitives.RoleArn.Type
    object S3Location extends Subtype[String]
    type S3Location = zio.aws.iottwinmaker.model.primitives.S3Location.Type
    object S3Url extends Subtype[String]
    type S3Url = zio.aws.iottwinmaker.model.primitives.S3Url.Type
    object SceneCapability extends Subtype[String]
    type SceneCapability =
      zio.aws.iottwinmaker.model.primitives.SceneCapability.Type
    object SceneMetadataValue extends Subtype[String]
    type SceneMetadataValue =
      zio.aws.iottwinmaker.model.primitives.SceneMetadataValue.Type
    object SyncSource extends Subtype[String]
    type SyncSource = zio.aws.iottwinmaker.model.primitives.SyncSource.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.iottwinmaker.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.iottwinmaker.model.primitives.TagValue.Type
    object Time extends Subtype[String]
    type Time = zio.aws.iottwinmaker.model.primitives.Time.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.iottwinmaker.model.primitives.Timestamp.Type
    object TwinMakerArn extends Subtype[String]
    type TwinMakerArn = zio.aws.iottwinmaker.model.primitives.TwinMakerArn.Type
    object Value extends Subtype[String]
    type Value = zio.aws.iottwinmaker.model.primitives.Value.Type
  }
  type ColumnDescriptions = List[zio.aws.iottwinmaker.model.ColumnDescription]
  type ComponentPropertyGroupRequests =
    Map[Name, zio.aws.iottwinmaker.model.ComponentPropertyGroupRequest]
  type ComponentPropertyGroupResponses =
    Map[Name, zio.aws.iottwinmaker.model.ComponentPropertyGroupResponse]
  type ComponentTypeSummaries =
    List[zio.aws.iottwinmaker.model.ComponentTypeSummary]
  type ComponentUpdatesMapRequest =
    Map[Name, zio.aws.iottwinmaker.model.ComponentUpdateRequest]
  type ComponentsMap = Map[Name, zio.aws.iottwinmaker.model.ComponentResponse]
  type ComponentsMapRequest =
    Map[Name, zio.aws.iottwinmaker.model.ComponentRequest]
  type Configuration = Map[Name, Value]
  type DataValueList = List[zio.aws.iottwinmaker.model.DataValue]
  type DataValueMap = Map[String, zio.aws.iottwinmaker.model.DataValue]
  type EntitySummaries = List[zio.aws.iottwinmaker.model.EntitySummary]
  type Entries = List[zio.aws.iottwinmaker.model.PropertyValueEntry]
  type ErrorEntries =
    List[zio.aws.iottwinmaker.model.BatchPutPropertyErrorEntry]
  type Errors = List[zio.aws.iottwinmaker.model.BatchPutPropertyError]
  type ExtendsFrom = List[ComponentTypeId]
  type ExternalIdProperty = Map[String, String]
  type FunctionsRequest = Map[Name, zio.aws.iottwinmaker.model.FunctionRequest]
  type FunctionsResponse =
    Map[Name, zio.aws.iottwinmaker.model.FunctionResponse]
  type GeneratedSceneMetadataMap = Map[Name, SceneMetadataValue]
  type ListComponentTypesFilters =
    List[zio.aws.iottwinmaker.model.ListComponentTypesFilter]
  type ListEntitiesFilters = List[zio.aws.iottwinmaker.model.ListEntitiesFilter]
  type OrderByList = List[zio.aws.iottwinmaker.model.OrderBy]
  type PricingBundles = List[BundleName]
  type PropertyDefinitionsRequest =
    Map[Name, zio.aws.iottwinmaker.model.PropertyDefinitionRequest]
  type PropertyDefinitionsResponse =
    Map[Name, zio.aws.iottwinmaker.model.PropertyDefinitionResponse]
  type PropertyFilters = List[zio.aws.iottwinmaker.model.PropertyFilter]
  type PropertyGroupsRequest =
    Map[Name, zio.aws.iottwinmaker.model.PropertyGroupRequest]
  type PropertyGroupsResponse =
    Map[Name, zio.aws.iottwinmaker.model.PropertyGroupResponse]
  type PropertyLatestValueMap =
    Map[Name, zio.aws.iottwinmaker.model.PropertyLatestValue]
  type PropertyNames = List[Name]
  type PropertyRequests = Map[Name, zio.aws.iottwinmaker.model.PropertyRequest]
  type PropertyResponses =
    Map[Name, zio.aws.iottwinmaker.model.PropertyResponse]
  type PropertyTableValue = Map[Name, zio.aws.iottwinmaker.model.DataValue]
  type PropertyValueList = List[zio.aws.iottwinmaker.model.PropertyValueHistory]
  type PropertyValues = List[zio.aws.iottwinmaker.model.PropertyValue]
  type QueryResultValue = Document
  type RequiredProperties = List[Name]
  type RowData = List[zio.aws.iottwinmaker.model.QueryResultValue]
  type Rows = List[zio.aws.iottwinmaker.model.Row]
  type SceneCapabilities = List[SceneCapability]
  type SceneMetadataMap = Map[Name, SceneMetadataValue]
  type SceneSummaries = List[zio.aws.iottwinmaker.model.SceneSummary]
  type SelectedPropertyList = List[String]
  type SyncJobSummaries = List[zio.aws.iottwinmaker.model.SyncJobSummary]
  type SyncResourceFilters = List[zio.aws.iottwinmaker.model.SyncResourceFilter]
  type SyncResourceSummaries =
    List[zio.aws.iottwinmaker.model.SyncResourceSummary]
  type TabularPropertyValue =
    List[Map[Name, zio.aws.iottwinmaker.model.DataValue]]
  type TabularPropertyValues =
    List[Iterable[Map[Name, zio.aws.iottwinmaker.model.DataValue]]]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type Values = List[zio.aws.iottwinmaker.model.PropertyValue]
  type WorkspaceSummaries = List[zio.aws.iottwinmaker.model.WorkspaceSummary]
}
