package zio.aws.ivschat.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ivschat.model.primitives.LogGroupName
import scala.jdk.CollectionConverters.*
final case class CloudWatchLogsDestinationConfiguration(
    logGroupName: LogGroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivschat.model.CloudWatchLogsDestinationConfiguration = {
    import CloudWatchLogsDestinationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivschat.model.CloudWatchLogsDestinationConfiguration
      .builder()
      .logGroupName(LogGroupName.unwrap(logGroupName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ivschat.model.CloudWatchLogsDestinationConfiguration.ReadOnly =
    zio.aws.ivschat.model.CloudWatchLogsDestinationConfiguration
      .wrap(buildAwsValue())
}
object CloudWatchLogsDestinationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivschat.model.CloudWatchLogsDestinationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ivschat.model.CloudWatchLogsDestinationConfiguration =
      zio.aws.ivschat.model.CloudWatchLogsDestinationConfiguration(logGroupName)
    def logGroupName: LogGroupName
    def getLogGroupName: ZIO[Any, Nothing, LogGroupName] =
      ZIO.succeed(logGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivschat.model.CloudWatchLogsDestinationConfiguration
  ) extends zio.aws.ivschat.model.CloudWatchLogsDestinationConfiguration.ReadOnly {
    override val logGroupName: LogGroupName =
      zio.aws.ivschat.model.primitives.LogGroupName(impl.logGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivschat.model.CloudWatchLogsDestinationConfiguration
  ): zio.aws.ivschat.model.CloudWatchLogsDestinationConfiguration.ReadOnly =
    new Wrapper(impl)
}
