package zio.aws.ivschat.model
import zio.aws.ivschat.model.primitives.{
  UserID,
  SessionDurationInMinutes,
  RoomIdentifier
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateChatTokenRequest(
    attributes: Optional[Map[String, String]] = Optional.Absent,
    capabilities: Optional[
      Iterable[zio.aws.ivschat.model.ChatTokenCapability]
    ] = Optional.Absent,
    roomIdentifier: RoomIdentifier,
    sessionDurationInMinutes: Optional[SessionDurationInMinutes] =
      Optional.Absent,
    userId: UserID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivschat.model.CreateChatTokenRequest = {
    import CreateChatTokenRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivschat.model.CreateChatTokenRequest
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.capabilitiesWithStrings)
      .roomIdentifier(RoomIdentifier.unwrap(roomIdentifier): java.lang.String)
      .optionallyWith(
        sessionDurationInMinutes.map(value =>
          SessionDurationInMinutes.unwrap(value): Integer
        )
      )(_.sessionDurationInMinutes)
      .userId(UserID.unwrap(userId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ivschat.model.CreateChatTokenRequest.ReadOnly =
    zio.aws.ivschat.model.CreateChatTokenRequest.wrap(buildAwsValue())
}
object CreateChatTokenRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivschat.model.CreateChatTokenRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivschat.model.CreateChatTokenRequest =
      zio.aws.ivschat.model.CreateChatTokenRequest(
        attributes.map(value => value),
        capabilities.map(value => value),
        roomIdentifier,
        sessionDurationInMinutes.map(value => value),
        userId
      )
    def attributes: Optional[Map[String, String]]
    def capabilities: Optional[List[zio.aws.ivschat.model.ChatTokenCapability]]
    def roomIdentifier: RoomIdentifier
    def sessionDurationInMinutes: Optional[SessionDurationInMinutes]
    def userId: UserID
    def getAttributes: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getCapabilities
        : ZIO[Any, AwsError, List[zio.aws.ivschat.model.ChatTokenCapability]] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getRoomIdentifier: ZIO[Any, Nothing, RoomIdentifier] =
      ZIO.succeed(roomIdentifier)
    def getSessionDurationInMinutes
        : ZIO[Any, AwsError, SessionDurationInMinutes] = AwsError
      .unwrapOptionField("sessionDurationInMinutes", sessionDurationInMinutes)
    def getUserId: ZIO[Any, Nothing, UserID] = ZIO.succeed(userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivschat.model.CreateChatTokenRequest
  ) extends zio.aws.ivschat.model.CreateChatTokenRequest.ReadOnly {
    override val attributes: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val capabilities
        : Optional[List[zio.aws.ivschat.model.ChatTokenCapability]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capabilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ivschat.model.ChatTokenCapability.wrap(item)
          }.toList
        )
    override val roomIdentifier: RoomIdentifier =
      zio.aws.ivschat.model.primitives.RoomIdentifier(impl.roomIdentifier())
    override val sessionDurationInMinutes: Optional[SessionDurationInMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionDurationInMinutes())
        .map(value =>
          zio.aws.ivschat.model.primitives.SessionDurationInMinutes(value)
        )
    override val userId: UserID =
      zio.aws.ivschat.model.primitives.UserID(impl.userId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivschat.model.CreateChatTokenRequest
  ): zio.aws.ivschat.model.CreateChatTokenRequest.ReadOnly = new Wrapper(impl)
}
