package zio.aws.ivschat.model
import scala.jdk.CollectionConverters.*
sealed trait FallbackResult {
  def unwrap: software.amazon.awssdk.services.ivschat.model.FallbackResult
}
object FallbackResult {
  def wrap(
      value: software.amazon.awssdk.services.ivschat.model.FallbackResult
  ): zio.aws.ivschat.model.FallbackResult = value match {
    case software.amazon.awssdk.services.ivschat.model.FallbackResult.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ivschat.model.FallbackResult.ALLOW =>
      val r = ALLOW
      r
    case software.amazon.awssdk.services.ivschat.model.FallbackResult.DENY =>
      val r = DENY
      r
  }
  case object unknownToSdkVersion extends zio.aws.ivschat.model.FallbackResult {
    override def unwrap
        : software.amazon.awssdk.services.ivschat.model.FallbackResult =
      software.amazon.awssdk.services.ivschat.model.FallbackResult.UNKNOWN_TO_SDK_VERSION
  }
  case object ALLOW extends zio.aws.ivschat.model.FallbackResult {
    override def unwrap
        : software.amazon.awssdk.services.ivschat.model.FallbackResult =
      software.amazon.awssdk.services.ivschat.model.FallbackResult.ALLOW
  }
  case object DENY extends zio.aws.ivschat.model.FallbackResult {
    override def unwrap
        : software.amazon.awssdk.services.ivschat.model.FallbackResult =
      software.amazon.awssdk.services.ivschat.model.FallbackResult.DENY
  }
}
