package zio.aws.ivschat.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.ivschat.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListLoggingConfigurationsResponse(
    loggingConfigurations: Iterable[
      zio.aws.ivschat.model.LoggingConfigurationSummary
    ],
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivschat.model.ListLoggingConfigurationsResponse = {
    import ListLoggingConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivschat.model.ListLoggingConfigurationsResponse
      .builder()
      .loggingConfigurations(loggingConfigurations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ivschat.model.ListLoggingConfigurationsResponse.ReadOnly =
    zio.aws.ivschat.model.ListLoggingConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListLoggingConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivschat.model.ListLoggingConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivschat.model.ListLoggingConfigurationsResponse =
      zio.aws.ivschat.model.ListLoggingConfigurationsResponse(
        loggingConfigurations.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def loggingConfigurations
        : List[zio.aws.ivschat.model.LoggingConfigurationSummary.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def getLoggingConfigurations: ZIO[Any, Nothing, List[
      zio.aws.ivschat.model.LoggingConfigurationSummary.ReadOnly
    ]] = ZIO.succeed(loggingConfigurations)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivschat.model.ListLoggingConfigurationsResponse
  ) extends zio.aws.ivschat.model.ListLoggingConfigurationsResponse.ReadOnly {
    override val loggingConfigurations
        : List[zio.aws.ivschat.model.LoggingConfigurationSummary.ReadOnly] =
      impl
        .loggingConfigurations()
        .asScala
        .map { item =>
          zio.aws.ivschat.model.LoggingConfigurationSummary.wrap(item)
        }
        .toList
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ivschat.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivschat.model.ListLoggingConfigurationsResponse
  ): zio.aws.ivschat.model.ListLoggingConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
