package zio.aws.ivschat.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.ivschat.model.primitives.{RoomIdentifier, EventName}
import scala.jdk.CollectionConverters.*
final case class SendEventRequest(
    attributes: Optional[Map[String, String]] = Optional.Absent,
    eventName: EventName,
    roomIdentifier: RoomIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivschat.model.SendEventRequest = {
    import SendEventRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivschat.model.SendEventRequest
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .eventName(EventName.unwrap(eventName): java.lang.String)
      .roomIdentifier(RoomIdentifier.unwrap(roomIdentifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ivschat.model.SendEventRequest.ReadOnly =
    zio.aws.ivschat.model.SendEventRequest.wrap(buildAwsValue())
}
object SendEventRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivschat.model.SendEventRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivschat.model.SendEventRequest =
      zio.aws.ivschat.model.SendEventRequest(
        attributes.map(value => value),
        eventName,
        roomIdentifier
      )
    def attributes: Optional[Map[String, String]]
    def eventName: EventName
    def roomIdentifier: RoomIdentifier
    def getAttributes: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getEventName: ZIO[Any, Nothing, EventName] = ZIO.succeed(eventName)
    def getRoomIdentifier: ZIO[Any, Nothing, RoomIdentifier] =
      ZIO.succeed(roomIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivschat.model.SendEventRequest
  ) extends zio.aws.ivschat.model.SendEventRequest.ReadOnly {
    override val attributes: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val eventName: EventName =
      zio.aws.ivschat.model.primitives.EventName(impl.eventName())
    override val roomIdentifier: RoomIdentifier =
      zio.aws.ivschat.model.primitives.RoomIdentifier(impl.roomIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivschat.model.SendEventRequest
  ): zio.aws.ivschat.model.SendEventRequest.ReadOnly = new Wrapper(impl)
}
