package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.{__string, __boolean}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CloudWatchLogs(
    enabled: __boolean,
    logGroup: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.CloudWatchLogs = {
    import CloudWatchLogs.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.CloudWatchLogs
      .builder()
      .enabled(__boolean.unwrap(enabled): java.lang.Boolean)
      .optionallyWith(
        logGroup.map(value => __string.unwrap(value): java.lang.String)
      )(_.logGroup)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.CloudWatchLogs.ReadOnly =
    zio.aws.kafka.model.CloudWatchLogs.wrap(buildAwsValue())
}
object CloudWatchLogs {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.CloudWatchLogs
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.CloudWatchLogs =
      zio.aws.kafka.model.CloudWatchLogs(enabled, logGroup.map(value => value))
    def enabled: __boolean
    def logGroup: Option[__string]
    def getEnabled: ZIO[Any, Nothing, __boolean] = ZIO.succeed(enabled)
    def getLogGroup: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("logGroup", logGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.CloudWatchLogs
  ) extends zio.aws.kafka.model.CloudWatchLogs.ReadOnly {
    override val enabled: __boolean =
      zio.aws.kafka.model.primitives.__boolean(impl.enabled())
    override val logGroup: Option[__string] = scala
      .Option(impl.logGroup())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.CloudWatchLogs
  ): zio.aws.kafka.model.CloudWatchLogs.ReadOnly = new Wrapper(impl)
}
