package zio.aws.kafka.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeClusterResponse(
    clusterInfo: Option[zio.aws.kafka.model.ClusterInfo] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.DescribeClusterResponse = {
    import DescribeClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.DescribeClusterResponse
      .builder()
      .optionallyWith(clusterInfo.map(value => value.buildAwsValue()))(
        _.clusterInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.DescribeClusterResponse.ReadOnly =
    zio.aws.kafka.model.DescribeClusterResponse.wrap(buildAwsValue())
}
object DescribeClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.DescribeClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.DescribeClusterResponse =
      zio.aws.kafka.model
        .DescribeClusterResponse(clusterInfo.map(value => value.asEditable))
    def clusterInfo: Option[zio.aws.kafka.model.ClusterInfo.ReadOnly]
    def getClusterInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.ClusterInfo.ReadOnly] =
      AwsError.unwrapOptionField("clusterInfo", clusterInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.DescribeClusterResponse
  ) extends zio.aws.kafka.model.DescribeClusterResponse.ReadOnly {
    override val clusterInfo: Option[zio.aws.kafka.model.ClusterInfo.ReadOnly] =
      scala
        .Option(impl.clusterInfo())
        .map(value => zio.aws.kafka.model.ClusterInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.DescribeClusterResponse
  ): zio.aws.kafka.model.DescribeClusterResponse.ReadOnly = new Wrapper(impl)
}
