package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeClusterV2Request(clusterArn: __string) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.DescribeClusterV2Request = {
    import DescribeClusterV2Request.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.DescribeClusterV2Request
      .builder()
      .clusterArn(__string.unwrap(clusterArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.DescribeClusterV2Request.ReadOnly =
    zio.aws.kafka.model.DescribeClusterV2Request.wrap(buildAwsValue())
}
object DescribeClusterV2Request {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.DescribeClusterV2Request
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.DescribeClusterV2Request =
      zio.aws.kafka.model.DescribeClusterV2Request(clusterArn)
    def clusterArn: __string
    def getClusterArn: ZIO[Any, Nothing, __string] = ZIO.succeed(clusterArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.DescribeClusterV2Request
  ) extends zio.aws.kafka.model.DescribeClusterV2Request.ReadOnly {
    override val clusterArn: __string =
      zio.aws.kafka.model.primitives.__string(impl.clusterArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.DescribeClusterV2Request
  ): zio.aws.kafka.model.DescribeClusterV2Request.ReadOnly = new Wrapper(impl)
}
