package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class KafkaVersion(
    version: Option[__string] = None,
    status: Option[zio.aws.kafka.model.KafkaVersionStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.KafkaVersion = {
    import KafkaVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.KafkaVersion
      .builder()
      .optionallyWith(
        version.map(value => __string.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.KafkaVersion.ReadOnly =
    zio.aws.kafka.model.KafkaVersion.wrap(buildAwsValue())
}
object KafkaVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.KafkaVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.KafkaVersion = zio.aws.kafka.model
      .KafkaVersion(version.map(value => value), status.map(value => value))
    def version: Option[__string]
    def status: Option[zio.aws.kafka.model.KafkaVersionStatus]
    def getVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("version", version)
    def getStatus: ZIO[Any, AwsError, zio.aws.kafka.model.KafkaVersionStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.KafkaVersion
  ) extends zio.aws.kafka.model.KafkaVersion.ReadOnly {
    override val version: Option[__string] = scala
      .Option(impl.version())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val status: Option[zio.aws.kafka.model.KafkaVersionStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.kafka.model.KafkaVersionStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.KafkaVersion
  ): zio.aws.kafka.model.KafkaVersion.ReadOnly = new Wrapper(impl)
}
