package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RebootBrokerRequest(
    brokerIds: Iterable[__string],
    clusterArn: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.RebootBrokerRequest = {
    import RebootBrokerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.RebootBrokerRequest
      .builder()
      .brokerIds(brokerIds.map { item =>
        __string.unwrap(item): java.lang.String
      }.asJavaCollection)
      .clusterArn(__string.unwrap(clusterArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.RebootBrokerRequest.ReadOnly =
    zio.aws.kafka.model.RebootBrokerRequest.wrap(buildAwsValue())
}
object RebootBrokerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.RebootBrokerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.RebootBrokerRequest =
      zio.aws.kafka.model.RebootBrokerRequest(brokerIds, clusterArn)
    def brokerIds: List[__string]
    def clusterArn: __string
    def getBrokerIds: ZIO[Any, Nothing, List[__string]] = ZIO.succeed(brokerIds)
    def getClusterArn: ZIO[Any, Nothing, __string] = ZIO.succeed(clusterArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.RebootBrokerRequest
  ) extends zio.aws.kafka.model.RebootBrokerRequest.ReadOnly {
    override val brokerIds: List[__string] = impl
      .brokerIds()
      .asScala
      .map { item =>
        zio.aws.kafka.model.primitives.__string(item)
      }
      .toList
    override val clusterArn: __string =
      zio.aws.kafka.model.primitives.__string(impl.clusterArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.RebootBrokerRequest
  ): zio.aws.kafka.model.RebootBrokerRequest.ReadOnly = new Wrapper(impl)
}
