package zio.aws.kafka.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ServerlessClientAuthentication(
    sasl: Option[zio.aws.kafka.model.ServerlessSasl] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ServerlessClientAuthentication = {
    import ServerlessClientAuthentication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ServerlessClientAuthentication
      .builder()
      .optionallyWith(sasl.map(value => value.buildAwsValue()))(_.sasl)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ServerlessClientAuthentication.ReadOnly =
    zio.aws.kafka.model.ServerlessClientAuthentication.wrap(buildAwsValue())
}
object ServerlessClientAuthentication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ServerlessClientAuthentication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ServerlessClientAuthentication =
      zio.aws.kafka.model
        .ServerlessClientAuthentication(sasl.map(value => value.asEditable))
    def sasl: Option[zio.aws.kafka.model.ServerlessSasl.ReadOnly]
    def getSasl
        : ZIO[Any, AwsError, zio.aws.kafka.model.ServerlessSasl.ReadOnly] =
      AwsError.unwrapOptionField("sasl", sasl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ServerlessClientAuthentication
  ) extends zio.aws.kafka.model.ServerlessClientAuthentication.ReadOnly {
    override val sasl: Option[zio.aws.kafka.model.ServerlessSasl.ReadOnly] =
      scala
        .Option(impl.sasl())
        .map(value => zio.aws.kafka.model.ServerlessSasl.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ServerlessClientAuthentication
  ): zio.aws.kafka.model.ServerlessClientAuthentication.ReadOnly = new Wrapper(
    impl
  )
}
