package zio.aws.kafka.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ServerlessSasl(iam: Option[zio.aws.kafka.model.Iam] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ServerlessSasl = {
    import ServerlessSasl.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ServerlessSasl
      .builder()
      .optionallyWith(iam.map(value => value.buildAwsValue()))(_.iam)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ServerlessSasl.ReadOnly =
    zio.aws.kafka.model.ServerlessSasl.wrap(buildAwsValue())
}
object ServerlessSasl {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ServerlessSasl
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ServerlessSasl =
      zio.aws.kafka.model.ServerlessSasl(iam.map(value => value.asEditable))
    def iam: Option[zio.aws.kafka.model.Iam.ReadOnly]
    def getIam: ZIO[Any, AwsError, zio.aws.kafka.model.Iam.ReadOnly] =
      AwsError.unwrapOptionField("iam", iam)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ServerlessSasl
  ) extends zio.aws.kafka.model.ServerlessSasl.ReadOnly {
    override val iam: Option[zio.aws.kafka.model.Iam.ReadOnly] =
      scala.Option(impl.iam()).map(value => zio.aws.kafka.model.Iam.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ServerlessSasl
  ): zio.aws.kafka.model.ServerlessSasl.ReadOnly = new Wrapper(impl)
}
